/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractEdge;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class CacheEdge
extends AbstractEdge {
    private final Entry data;

    public CacheEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end, Entry data) {
        super(id, label, start.it(), end.it());
        assert (data != null);
        this.data = data;
    }

    public Direction getVertexCentricDirection() {
        return this.data.getCache().direction;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            final long id = super.longId();
            List<InternalRelation> previous = startVertex.getAddedRelations(new Predicate<InternalRelation>(){

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return internalRelation instanceof StandardEdge && ((StandardEdge)internalRelation).getPreviousID() == id;
                }
            });
            assert (Iterables.size(previous) <= 1 || this.isLoop() && Iterables.size(previous) == 2);
            it = (InternalRelation)Iterables.getFirst(previous, null);
        }
        if (it != null) {
            return it;
        }
        return super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            PropertyKey type = this.tx().getExistingPropertyKey(entry.key);
            if (type instanceof ImplicitKey) continue;
            to.setPropertyDirect(type, entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardEdge copy = new StandardEdge(super.longId(), this.edgeLabel(), this.getVertex(0), this.getVertex(1), 2);
        this.copyProperties(copy);
        copy.remove();
        StandardEdge u = (StandardEdge)this.tx().addEdge(this.getVertex(0), this.getVertex(1), this.edgeLabel());
        if (this.type.getConsistencyModifier() != ConsistencyModifier.FORK) {
            u.setId(super.longId());
        }
        u.setPreviousID(super.longId());
        this.copyProperties(u);
        this.setId(u.longId());
        return u;
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = RelationConstructor.readRelationCache(this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getValueDirect(PropertyKey key) {
        return this.getPropertyMap().get(key.longId());
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<PropertyKey> types = new ArrayList<PropertyKey>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingPropertyKey(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(PropertyKey key, Object value) {
        this.update().setPropertyDirect(key, value);
    }

    @Override
    public <O> O removePropertyDirect(PropertyKey key) {
        return this.update().removePropertyDirect(key);
    }

    @Override
    public byte getLifeCycle() {
        InternalVertex startVertex = this.getVertex(0);
        return (byte)((startVertex.hasRemovedRelations() || startVertex.isRemoved()) && this.tx().isRemovedRelation(super.longId()) ? 6 : 2);
    }

    @Override
    public void remove() {
        if (!this.tx().isRemovedRelation(super.longId())) {
            this.tx().removeRelation(this);
        }
    }
}

