/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class AdjacentVertexFilterOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final AdjacentVertexFilterOptimizerStrategy INSTANCE = new AdjacentVertexFilterOptimizerStrategy();

    private AdjacentVertexFilterOptimizerStrategy() {
    }

    public static AdjacentVertexFilterOptimizerStrategy instance() {
        return INSTANCE;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(TraversalFilterStep.class, traversal).forEach(originalStep -> {
            Traversal.Admin filterTraversal = (Traversal.Admin)originalStep.getLocalChildren().get(0);
            List steps = filterTraversal.getSteps();
            if (steps.size() == 2 && (steps.get(0) instanceof EdgeVertexStep || steps.get(0) instanceof EdgeOtherVertexStep) && steps.get(1) instanceof IsStep) {
                Direction direction = null;
                if (steps.get(0) instanceof EdgeVertexStep) {
                    EdgeVertexStep evs = (EdgeVertexStep)steps.get(0);
                    if (evs.getDirection() != Direction.BOTH) {
                        direction = evs.getDirection();
                    }
                } else {
                    assert (steps.get(0) instanceof EdgeOtherVertexStep);
                    direction = Direction.BOTH;
                }
                P predicate = ((IsStep)steps.get(1)).getPredicate();
                if (direction != null && predicate.getBiPredicate() == Compare.eq && predicate.getValue() instanceof Vertex) {
                    VertexStep vstep;
                    JanusGraphVertex vertex = JanusGraphTraversalUtil.getJanusGraphVertex((Element)((Vertex)predicate.getValue()));
                    Step currentStep = originalStep.getPreviousStep();
                    while (currentStep instanceof HasStep || currentStep instanceof IdentityStep) {
                    }
                    if (currentStep instanceof VertexStep && (vstep = (VertexStep)currentStep).returnsEdge() && (direction == Direction.BOTH || direction.equals((Object)vstep.getDirection().opposite()))) {
                        TraversalHelper.replaceStep((Step)originalStep, (Step)new HasStep(traversal, HasContainer.makeHasContainers((String)ImplicitKey.ADJACENT_ID.name(), (P)P.eq((Object)vertex))), (Traversal.Admin)traversal);
                    }
                }
            }
        });
    }
}

