/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.CacheEdge;
import org.janusgraph.graphdb.relations.CacheVertexProperty;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.VertexFactory;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.TypeUtil;

public class RelationConstructor {
    public static RelationCache readRelationCache(Entry data, StandardJanusGraphTx tx) {
        return tx.getEdgeSerializer().readRelation(data, false, tx);
    }

    public static Iterable<JanusGraphRelation> readRelation(final InternalVertex vertex, final Iterable<Entry> data, final StandardJanusGraphTx tx) {
        return new Iterable<JanusGraphRelation>(){

            @Override
            public Iterator<JanusGraphRelation> iterator() {
                return new Iterator<JanusGraphRelation>(){
                    Iterator<Entry> iter;
                    JanusGraphRelation current;
                    {
                        this.iter = data.iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public JanusGraphRelation next() {
                        this.current = RelationConstructor.readRelation(vertex, this.iter.next(), tx);
                        return this.current;
                    }

                    @Override
                    public void remove() {
                        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
                        this.current.remove();
                    }
                };
            }
        };
    }

    public static InternalRelation readRelation(InternalVertex vertex, Entry data, StandardJanusGraphTx tx) {
        RelationCache relation = tx.getEdgeSerializer().readRelation(data, true, tx);
        return RelationConstructor.readRelation(vertex, relation, data, (TypeInspector)tx, (VertexFactory)tx);
    }

    public static InternalRelation readRelation(InternalVertex vertex, Entry data, EdgeSerializer serializer, TypeInspector types, VertexFactory vertexFac) {
        RelationCache relation = serializer.readRelation(data, true, types);
        return RelationConstructor.readRelation(vertex, relation, data, types, vertexFac);
    }

    private static InternalRelation readRelation(InternalVertex vertex, RelationCache relation, Entry data, TypeInspector types, VertexFactory vertexFac) {
        InternalRelationType type = TypeUtil.getBaseType((InternalRelationType)types.getExistingRelationType(relation.typeId));
        if (type.isPropertyKey()) {
            assert (relation.direction == Direction.OUT);
            return new CacheVertexProperty(relation.relationId, (PropertyKey)((Object)type), vertex, relation.getValue(), data);
        }
        if (type.isEdgeLabel()) {
            InternalVertex otherVertex = vertexFac.getInternalVertex(relation.getOtherVertexId());
            switch (relation.direction) {
                case IN: {
                    return new CacheEdge(relation.relationId, (EdgeLabel)((Object)type), otherVertex, vertex, data);
                }
                case OUT: {
                    return new CacheEdge(relation.relationId, (EdgeLabel)((Object)type), vertex, otherVertex, data);
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }
}

