/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaInspector;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.idassigner.IDPool;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.MetricsQueryExecutor;
import org.janusgraph.graphdb.query.QueryExecutor;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.graph.IndexQueryBuilder;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.MultiVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.VertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.RelationComparator;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsTransaction;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.janusgraph.graphdb.transaction.VertexFactory;
import org.janusgraph.graphdb.transaction.VertexIterable;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;
import org.janusgraph.graphdb.transaction.addedrelations.ConcurrentBufferAddedRelations;
import org.janusgraph.graphdb.transaction.addedrelations.SimpleBufferAddedRelations;
import org.janusgraph.graphdb.transaction.indexcache.ConcurrentIndexCache;
import org.janusgraph.graphdb.transaction.indexcache.IndexCache;
import org.janusgraph.graphdb.transaction.indexcache.SimpleIndexCache;
import org.janusgraph.graphdb.transaction.lock.CombinerLock;
import org.janusgraph.graphdb.transaction.lock.FakeLock;
import org.janusgraph.graphdb.transaction.lock.IndexLockTuple;
import org.janusgraph.graphdb.transaction.lock.LockTuple;
import org.janusgraph.graphdb.transaction.lock.ReentrantTransactionLock;
import org.janusgraph.graphdb.transaction.lock.TransactionLock;
import org.janusgraph.graphdb.transaction.vertexcache.GuavaVertexCache;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.StandardPropertyKeyMaker;
import org.janusgraph.graphdb.types.StandardVertexLabelMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;
import org.janusgraph.graphdb.types.system.SystemTypeManager;
import org.janusgraph.graphdb.types.vertices.EdgeLabelVertex;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.PropertyKeyVertex;
import org.janusgraph.graphdb.util.IndexHelper;
import org.janusgraph.graphdb.util.VertexCentricEdgeIterable;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.graphdb.vertices.PreloadedVertex;
import org.janusgraph.graphdb.vertices.StandardVertex;
import org.janusgraph.util.datastructures.Retriever;
import org.janusgraph.util.stats.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJanusGraphTx
extends JanusGraphBlueprintsTransaction
implements TypeInspector,
SchemaInspector,
VertexFactory {
    private static final Logger log = LoggerFactory.getLogger(StandardJanusGraphTx.class);
    private static final Map<Long, InternalRelation> EMPTY_DELETED_RELATIONS = ImmutableMap.of();
    private static final ConcurrentMap<LockTuple, TransactionLock> UNINITIALIZED_LOCKS = null;
    private static final Duration LOCK_TIMEOUT = Duration.ofMillis(5000L);
    private static final long MIN_VERTEX_CACHE_SIZE = 100L;
    private final StandardJanusGraph graph;
    private final TransactionConfiguration config;
    private final IDManager idManager;
    private final IDManager idInspector;
    private final AttributeHandler attributeHandler;
    private BackendTransaction txHandle;
    private final EdgeSerializer edgeSerializer;
    private final IndexSerializer indexSerializer;
    private final VertexCache vertexCache;
    private final AddedRelationsContainer addedRelations;
    private Map<Long, InternalRelation> deletedRelations;
    private final Cache<JointIndexQuery.Subquery, List<Object>> indexCache;
    private final IndexCache newVertexIndexEntries;
    private ConcurrentMap<LockTuple, TransactionLock> uniqueLocks;
    private final Map<String, Long> newTypeCache;
    private final IDPool temporaryIds;
    private final TimestampProvider times;
    private boolean isOpen;
    private final VertexConstructor existingVertexRetriever;
    private final VertexConstructor externalVertexRetriever;
    private final VertexConstructor internalVertexRetriever;
    public final QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery> edgeProcessor;
    public final QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery> edgeProcessorImpl = new QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery>(){

        @Override
        public Iterator<JanusGraphRelation> getNew(final VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew() || vertex.hasAddedRelations()) {
                return vertex.getAddedRelations(new Predicate<InternalRelation>(){
                    private JanusGraphRelation previous = null;

                    public boolean apply(@Nullable InternalRelation relation) {
                        if (relation instanceof JanusGraphEdge && relation.isLoop() && query.getDirection() != Direction.BOTH) {
                            if (relation.equals(this.previous)) {
                                return false;
                            }
                            this.previous = relation;
                        }
                        return query.matches(relation);
                    }
                }).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasDeletions(VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew()) {
                return false;
            }
            return vertex.hasRemovedRelations() || vertex.hasAddedRelations();
        }

        @Override
        public boolean isDeleted(VertexCentricQuery query, JanusGraphRelation result) {
            RelationComparator comparator;
            if (StandardJanusGraphTx.this.deletedRelations.containsKey(result.longId()) || result != ((InternalRelation)result).it()) {
                return true;
            }
            InternalRelationType type = (InternalRelationType)result.getType();
            InternalVertex vertex = query.getVertex();
            return type.multiplicity().isConstrained() && vertex.hasAddedRelations() && !Iterables.isEmpty(vertex.getAddedRelations(new Predicate<InternalRelation>(comparator = new RelationComparator(vertex), result){
                final /* synthetic */ RelationComparator val$comparator;
                final /* synthetic */ JanusGraphRelation val$result;
                {
                    this.val$comparator = relationComparator;
                    this.val$result = janusGraphRelation;
                }

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return this.val$comparator.compare((InternalRelation)this.val$result, internalRelation) == 0;
                }
            }));
        }

        @Override
        public Iterator<JanusGraphRelation> execute(VertexCentricQuery query, SliceQuery sq, Object exeInfo, final QueryProfiler profiler) {
            assert (exeInfo == null);
            if (query.getVertex().isNew()) {
                return Collections.emptyIterator();
            }
            final InternalVertex v = query.getVertex();
            EntryList iter = v.loadRelations(sq, new Retriever<SliceQuery, EntryList>(){

                @Override
                public EntryList get(SliceQuery query) {
                    return QueryProfiler.profile(profiler, query, q -> StandardJanusGraphTx.this.graph.edgeQuery(v.longId(), (SliceQuery)q, StandardJanusGraphTx.this.txHandle));
                }
            });
            return RelationConstructor.readRelation(v, iter, StandardJanusGraphTx.this).iterator();
        }
    };
    public final QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery> elementProcessor;
    public final QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery> elementProcessorImpl = new QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(){

        private PredicateCondition<PropertyKey, JanusGraphElement> getEqualityCondition(Condition<JanusGraphElement> condition) {
            if (condition instanceof PredicateCondition) {
                PredicateCondition pc = (PredicateCondition)condition;
                if (pc.getPredicate() == Cmp.EQUAL && TypeUtil.hasSimpleInternalVertexKeyIndex((PropertyKey)pc.getKey())) {
                    return pc;
                }
            } else if (condition instanceof And) {
                for (Condition<JanusGraphElement> condition2 : ((And)condition).getChildren()) {
                    PredicateCondition<PropertyKey, JanusGraphElement> p = this.getEqualityCondition(condition2);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        @Override
        public Iterator<JanusGraphElement> getNew(final GraphCentricQuery query) {
            if (query.numSubQueries() == 1 && query.getSubQuery(0).getBackendQuery().isEmpty()) {
                return Collections.emptyIterator();
            }
            Preconditions.checkArgument((boolean)query.getCondition().hasChildren(), (Object)"If the query is non-empty it needs to have a condition");
            if (query.getResultType() == ElementCategory.VERTEX && StandardJanusGraphTx.this.hasModifications()) {
                Iterator vertices;
                Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(query.getCondition()));
                PredicateCondition<PropertyKey, JanusGraphElement> standardIndexKey = this.getEqualityCondition(query.getCondition());
                if (standardIndexKey == null) {
                    final HashSet keys = Sets.newHashSet();
                    ConditionUtil.traversal(query.getCondition(), new Predicate<Condition<JanusGraphElement>>(){

                        public boolean apply(@Nullable Condition<JanusGraphElement> cond) {
                            Preconditions.checkArgument((cond.getType() != Condition.Type.LITERAL || cond instanceof PredicateCondition ? 1 : 0) != 0);
                            if (cond instanceof PredicateCondition) {
                                keys.add(((PredicateCondition)cond).getKey());
                            }
                            return true;
                        }
                    });
                    Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (String)"Invalid query condition: %s", (Object[])new Object[]{query.getCondition()});
                    HashSet vertexSet = Sets.newHashSet();
                    for (JanusGraphRelation janusGraphRelation : StandardJanusGraphTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                        public boolean apply(@Nullable InternalRelation relation) {
                            return keys.contains(relation.getType());
                        }
                    })) {
                        vertexSet.add(((JanusGraphVertexProperty)janusGraphRelation).element());
                    }
                    for (JanusGraphRelation janusGraphRelation : StandardJanusGraphTx.this.deletedRelations.values()) {
                        JanusGraphVertex v;
                        if (!keys.contains(janusGraphRelation.getType()) || (v = ((JanusGraphVertexProperty)janusGraphRelation).element()).isRemoved()) continue;
                        vertexSet.add(v);
                    }
                    vertices = vertexSet.iterator();
                } else {
                    vertices = Iterators.transform(StandardJanusGraphTx.this.newVertexIndexEntries.get(standardIndexKey.getValue(), standardIndexKey.getKey()).iterator(), (Function)new Function<JanusGraphVertexProperty, JanusGraphVertex>(){

                        @Nullable
                        public JanusGraphVertex apply(@Nullable JanusGraphVertexProperty o) {
                            return o.element();
                        }
                    });
                }
                return Iterators.filter((Iterator)vertices, (Predicate)new Predicate<JanusGraphVertex>(){

                    public boolean apply(@Nullable JanusGraphVertex vertex) {
                        return query.matches(vertex);
                    }
                });
            }
            if (!(query.getResultType() != ElementCategory.EDGE && query.getResultType() != ElementCategory.PROPERTY || StandardJanusGraphTx.this.addedRelations.isEmpty())) {
                return StandardJanusGraphTx.this.addedRelations.getView(new Predicate<InternalRelation>(){

                    public boolean apply(@Nullable InternalRelation relation) {
                        return query.getResultType().isInstance(relation) && !relation.isInvisible() && query.matches(relation);
                    }
                }).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasDeletions(GraphCentricQuery query) {
            return StandardJanusGraphTx.this.hasModifications();
        }

        @Override
        public boolean isDeleted(GraphCentricQuery query, JanusGraphElement result) {
            if (result == null || result.isRemoved()) {
                return true;
            }
            if (query.getResultType() == ElementCategory.VERTEX) {
                Preconditions.checkArgument((boolean)(result instanceof InternalVertex));
                InternalVertex v = ((InternalVertex)result).it();
                if (v.hasAddedRelations() || v.hasRemovedRelations()) {
                    return !query.matches(result);
                }
                return false;
            }
            if (query.getResultType() == ElementCategory.EDGE || query.getResultType() == ElementCategory.PROPERTY) {
                Preconditions.checkArgument((result.isLoaded() || result.isNew() ? 1 : 0) != 0);
                return result.isNew() && !query.matches(result);
            }
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
        }

        @Override
        public Iterator<JanusGraphElement> execute(GraphCentricQuery query, JointIndexQuery indexQuery, Object exeInfo, QueryProfiler profiler) {
            ArrayList retrievals;
            if (!indexQuery.isEmpty()) {
                retrievals = new ArrayList();
                for (int i = 0; i < indexQuery.size(); ++i) {
                    final JointIndexQuery.Subquery subquery = indexQuery.getQuery(i);
                    retrievals.add(new QueryUtil.IndexCall<Object>(){

                        @Override
                        public Collection<Object> call(int limit) {
                            final JointIndexQuery.Subquery adjustedQuery = subquery.updateLimit(limit);
                            try {
                                return (Collection)StandardJanusGraphTx.this.indexCache.get((Object)adjustedQuery, (Callable)new Callable<List<Object>>(){

                                    @Override
                                    public List<Object> call() throws Exception {
                                        return QueryProfiler.profile(subquery.getProfiler(), adjustedQuery, q -> StandardJanusGraphTx.this.indexSerializer.query((JointIndexQuery.Subquery)q, StandardJanusGraphTx.this.txHandle));
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new JanusGraphException("Could not call index", e.getCause());
                            }
                        }
                    });
                }
            } else {
                if (StandardJanusGraphTx.this.config.hasForceIndexUsage()) {
                    throw new JanusGraphException("Could not find a suitable index to answer graph query and graph scans are disabled: " + query);
                }
                log.warn("Query requires iterating over all vertices [{}]. For better performance, use indexes", query.getCondition());
                QueryProfiler sub = profiler.addNested("scan");
                sub.setAnnotation("query", indexQuery);
                sub.setAnnotation("fullscan", true);
                sub.setAnnotation("condition", (Object)query.getResultType());
                switch (query.getResultType()) {
                    case VERTEX: {
                        return StandardJanusGraphTx.this.getVertices(new long[0]).iterator();
                    }
                    case EDGE: {
                        return StandardJanusGraphTx.this.getEdges(new RelationIdentifier[0]).iterator();
                    }
                    case PROPERTY: {
                        return new VertexCentricEdgeIterable(StandardJanusGraphTx.this.getInternalVertices(), RelationCategory.PROPERTY).iterator();
                    }
                }
                throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
            }
            List resultSet = QueryUtil.processIntersectingRetrievals(retrievals, indexQuery.getLimit());
            Iterator iter = Iterators.transform(resultSet.iterator(), StandardJanusGraphTx.this.getConversionFunction(query.getResultType()));
            return iter;
        }
    };
    private final Function<Object, JanusGraphVertex> vertexIDConversionFct = new Function<Object, JanusGraphVertex>(){

        public JanusGraphVertex apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof Long));
            return StandardJanusGraphTx.this.getInternalVertex((Long)id);
        }
    };
    private final Function<Object, JanusGraphEdge> edgeIDConversionFct = new Function<Object, JanusGraphEdge>(){

        public JanusGraphEdge apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
            return ((RelationIdentifier)id).findEdge(StandardJanusGraphTx.this);
        }
    };
    private final Function<Object, JanusGraphVertexProperty> propertyIDConversionFct = new Function<Object, JanusGraphVertexProperty>(){

        public JanusGraphVertexProperty apply(@Nullable Object id) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
            return ((RelationIdentifier)id).findProperty(StandardJanusGraphTx.this);
        }
    };

    public StandardJanusGraphTx(StandardJanusGraph graph, TransactionConfiguration config) {
        int concurrencyLevel;
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)graph.isOpen());
        Preconditions.checkNotNull((Object)config);
        this.graph = graph;
        this.times = graph.getConfiguration().getTimestampProvider();
        this.config = config;
        this.idInspector = this.idManager = graph.getIDManager();
        this.attributeHandler = graph.getDataSerializer();
        this.edgeSerializer = graph.getEdgeSerializer();
        this.indexSerializer = graph.getIndexSerializer();
        this.temporaryIds = new IDPool(){
            private final AtomicLong counter = new AtomicLong(1L);

            @Override
            public long nextID() {
                return this.counter.getAndIncrement();
            }

            @Override
            public void close() {
            }
        };
        if (config.isSingleThreaded()) {
            this.addedRelations = new SimpleBufferAddedRelations();
            concurrencyLevel = 1;
            this.newTypeCache = new HashMap<String, Long>();
            this.newVertexIndexEntries = new SimpleIndexCache();
        } else {
            this.addedRelations = new ConcurrentBufferAddedRelations();
            concurrencyLevel = 1;
            this.newTypeCache = new NonBlockingHashMap();
            this.newVertexIndexEntries = new ConcurrentIndexCache();
        }
        boolean preloadedData = config.hasPreloadedData();
        this.externalVertexRetriever = new VertexConstructor(config.hasVerifyExternalVertexExistence(), preloadedData);
        this.internalVertexRetriever = new VertexConstructor(config.hasVerifyInternalVertexExistence(), preloadedData);
        this.existingVertexRetriever = new VertexConstructor(false, preloadedData);
        long effectiveVertexCacheSize = config.getVertexCacheSize();
        if (!config.isReadOnly()) {
            effectiveVertexCacheSize = Math.max(100L, effectiveVertexCacheSize);
            log.debug("Guava vertex cache size: requested={} effective={} (min={})", new Object[]{config.getVertexCacheSize(), effectiveVertexCacheSize, 100L});
        }
        this.vertexCache = new GuavaVertexCache(effectiveVertexCacheSize, concurrencyLevel, config.getDirtyVertexSize());
        this.indexCache = CacheBuilder.newBuilder().weigher((Weigher)new Weigher<JointIndexQuery.Subquery, List<Object>>(){

            public int weigh(JointIndexQuery.Subquery q, List<Object> r) {
                return 2 + r.size();
            }
        }).concurrencyLevel(concurrencyLevel).maximumWeight(config.getIndexCacheWeight()).build();
        this.uniqueLocks = UNINITIALIZED_LOCKS;
        this.deletedRelations = EMPTY_DELETED_RELATIONS;
        this.isOpen = true;
        if (null != config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(config.getGroupName(), "tx", "begin").inc();
            this.elementProcessor = new MetricsQueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(config.getGroupName(), "graph", this.elementProcessorImpl);
            this.edgeProcessor = new MetricsQueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery>(config.getGroupName(), "vertex", this.edgeProcessorImpl);
        } else {
            this.elementProcessor = this.elementProcessorImpl;
            this.edgeProcessor = this.edgeProcessorImpl;
        }
    }

    public void setBackendTransaction(BackendTransaction txHandle) {
        Preconditions.checkArgument((this.txHandle == null && txHandle != null ? 1 : 0) != 0);
        this.txHandle = txHandle;
    }

    private void verifyWriteAccess(JanusGraphVertex ... vertices) {
        if (this.config.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot create new entities in read-only transaction");
        }
        for (JanusGraphVertex v : vertices) {
            if (!v.hasId() || !this.idInspector.isUnmodifiableVertex(v.longId()) || v.isNew()) continue;
            throw new SchemaViolationException("Cannot modify unmodifiable vertex: " + v);
        }
        this.verifyAccess(vertices);
    }

    public final void verifyAccess(JanusGraphVertex ... vertices) {
        this.verifyOpen();
        for (JanusGraphVertex v : vertices) {
            Preconditions.checkArgument((boolean)(v instanceof InternalVertex), (String)"Invalid vertex: %s", (Object[])new Object[]{v});
            if (!(v instanceof SystemRelationType) && this != ((InternalVertex)v).tx()) {
                throw new IllegalStateException("The vertex or type is not associated with this transaction [" + v + "]");
            }
            if (!v.isRemoved()) continue;
            throw new IllegalStateException("The vertex or type has been removed [" + v + "]");
        }
    }

    private void verifyOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Operation cannot be executed because the enclosing transaction is closed");
        }
    }

    public StandardJanusGraphTx getNextTx() {
        Preconditions.checkArgument((boolean)this.isClosed());
        if (!this.config.isThreadBound()) {
            throw new IllegalStateException("Cannot access element because its enclosing transaction is closed and unbound");
        }
        return (StandardJanusGraphTx)this.graph.getCurrentThreadTx();
    }

    public TransactionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public StandardJanusGraph getGraph() {
        return this.graph;
    }

    public BackendTransaction getTxHandle() {
        return this.txHandle;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public IDManager getIdInspector() {
        return this.idInspector;
    }

    public boolean isPartitionedVertex(JanusGraphVertex vertex) {
        return vertex.hasId() && this.idInspector.isPartitionedVertex(vertex.longId());
    }

    public InternalVertex getCanonicalVertex(InternalVertex partitionedVertex) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        long canonicalId = this.idManager.getCanonicalVertexId(partitionedVertex.longId());
        if (canonicalId == partitionedVertex.longId()) {
            return partitionedVertex;
        }
        return this.getExistingVertex(canonicalId);
    }

    public InternalVertex getOtherPartitionVertex(JanusGraphVertex partitionedVertex, long otherPartition) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        return this.getExistingVertex(this.idManager.getPartitionedVertexId(partitionedVertex.longId(), otherPartition));
    }

    public InternalVertex[] getAllRepresentatives(JanusGraphVertex partitionedVertex, boolean restrict2Partitions) {
        int i;
        long[] ids;
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        if (!restrict2Partitions || !this.config.hasRestrictedPartitions()) {
            ids = this.idManager.getPartitionedVertexRepresentatives(partitionedVertex.longId());
        } else {
            int[] restrictedParititions = this.config.getRestrictedPartitions();
            ids = new long[restrictedParititions.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = this.idManager.getPartitionedVertexId(partitionedVertex.longId(), restrictedParititions[i]);
            }
        }
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0);
        InternalVertex[] vertices = new InternalVertex[ids.length];
        for (i = 0; i < ids.length; ++i) {
            vertices[i] = this.getExistingVertex(ids[i]);
        }
        return vertices;
    }

    public boolean containsVertex(long vertexid) {
        return this.getVertex(vertexid) != null;
    }

    private boolean isValidVertexId(long id) {
        return id > 0L && (this.idInspector.isSchemaVertexId(id) || this.idInspector.isUserVertexId(id));
    }

    @Override
    public JanusGraphVertex getVertex(long vertexid) {
        this.verifyOpen();
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getVertexByID").inc();
        }
        if (!this.isValidVertexId(vertexid)) {
            return null;
        }
        if (this.idInspector.isPartitionedVertex(vertexid)) {
            vertexid = this.idManager.getCanonicalVertexId(vertexid);
        }
        InternalVertex v = null;
        v = this.vertexCache.get(vertexid, this.externalVertexRetriever);
        return null == v || v.isRemoved() ? null : v;
    }

    @Override
    public Iterable<JanusGraphVertex> getVertices(long ... ids) {
        this.verifyOpen();
        if (ids == null || ids.length == 0) {
            return this.getInternalVertices();
        }
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getVerticesByID").inc();
        }
        ArrayList<JanusGraphVertex> result = new ArrayList<JanusGraphVertex>(ids.length);
        LongArrayList vids = new LongArrayList(ids.length);
        for (long id : ids) {
            if (!this.isValidVertexId(id)) continue;
            if (this.idInspector.isPartitionedVertex(id)) {
                id = this.idManager.getCanonicalVertexId(id);
            }
            if (this.vertexCache.contains(id)) {
                result.add(this.vertexCache.get(id, this.existingVertexRetriever));
                continue;
            }
            vids.add(id);
        }
        if (!vids.isEmpty()) {
            if (this.externalVertexRetriever.hasVerifyExistence()) {
                List<EntryList> existence = this.graph.edgeMultiQuery(vids, this.graph.vertexExistenceQuery, this.txHandle);
                for (int i = 0; i < vids.size(); ++i) {
                    if (existence.get(i).isEmpty()) continue;
                    long id = vids.get(i);
                    result.add(this.vertexCache.get(id, this.existingVertexRetriever));
                }
            } else {
                for (int i = 0; i < vids.size(); ++i) {
                    result.add(this.vertexCache.get(vids.get(i), this.externalVertexRetriever));
                }
            }
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            if (!((JanusGraphVertex)iterator.next()).isRemoved()) continue;
            iterator.remove();
        }
        return result;
    }

    private InternalVertex getExistingVertex(long vertexid) {
        return this.vertexCache.get(vertexid, this.existingVertexRetriever);
    }

    @Override
    public InternalVertex getInternalVertex(long vertexid) {
        return this.vertexCache.get(vertexid, this.internalVertexRetriever);
    }

    @Override
    public JanusGraphVertex addVertex(Long vertexId, VertexLabel label) {
        this.verifyWriteAccess(new JanusGraphVertex[0]);
        if (label == null) {
            label = BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        if (vertexId != null && !this.graph.getConfiguration().allowVertexIdSetting()) {
            log.info("Provided vertex id [{}] is ignored because vertex id setting is not enabled", (Object)vertexId);
            vertexId = null;
        }
        Preconditions.checkArgument((vertexId != null || !this.graph.getConfiguration().allowVertexIdSetting() ? 1 : 0) != 0, (Object)"Must provide vertex id");
        Preconditions.checkArgument((vertexId == null || IDManager.VertexIDType.NormalVertex.is(vertexId) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexId});
        Preconditions.checkArgument((vertexId == null || ((InternalVertexLabel)label).hasDefaultConfiguration() ? 1 : 0) != 0, (String)"Cannot only use default vertex labels: %s", (Object[])new Object[]{label});
        Preconditions.checkArgument((vertexId == null || !this.config.hasVerifyExternalVertexExistence() || !this.containsVertex(vertexId) ? 1 : 0) != 0, (String)"Vertex with given id already exists: %s", (Object[])new Object[]{vertexId});
        StandardVertex vertex = new StandardVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.NormalVertex, this.temporaryIds.nextID()), 1);
        if (vertexId != null) {
            vertex.setId(vertexId);
        } else if (this.config.hasAssignIDsImmediately() || label.isPartitioned()) {
            this.graph.assignID(vertex, label);
        }
        this.addProperty(vertex, BaseKey.VertexExists, Boolean.TRUE);
        if (label != BaseVertexLabel.DEFAULT_VERTEXLABEL) {
            Preconditions.checkArgument((boolean)(label instanceof VertexLabelVertex));
            this.addEdge(vertex, (VertexLabelVertex)label, BaseLabel.VertexLabelEdge);
        }
        this.vertexCache.add(vertex, vertex.longId());
        return vertex;
    }

    @Override
    public JanusGraphVertex addVertex(String vertexLabel) {
        return this.addVertex(this.getOrCreateVertexLabel(vertexLabel));
    }

    public JanusGraphVertex addVertex(VertexLabel vertexLabel) {
        return this.addVertex(null, vertexLabel);
    }

    private Iterable<InternalVertex> getInternalVertices() {
        Iterable<InternalVertex> allVertices;
        if (!this.addedRelations.isEmpty()) {
            List<InternalVertex> newVs = this.vertexCache.getAllNew();
            Iterator<InternalVertex> viter = newVs.iterator();
            while (viter.hasNext()) {
                if (!(viter.next() instanceof JanusGraphSchemaElement)) continue;
                viter.remove();
            }
            allVertices = Iterables.concat(newVs, (Iterable)new VertexIterable(this.graph, this));
        } else {
            allVertices = new VertexIterable(this.graph, this);
        }
        return Iterables.filter((Iterable)allVertices, (Predicate)new Predicate<InternalVertex>(){

            public boolean apply(@Nullable InternalVertex internalVertex) {
                return !StandardJanusGraphTx.this.isPartitionedVertex(internalVertex) || internalVertex.longId() == StandardJanusGraphTx.this.idInspector.getCanonicalVertexId(internalVertex.longId());
            }
        });
    }

    public final boolean validDataType(Class datatype) {
        return this.attributeHandler.validDataType(datatype);
    }

    public final Object verifyAttribute(PropertyKey key, Object attribute) {
        if (attribute == null) {
            throw new SchemaViolationException("Property value cannot be null");
        }
        Class<?> datatype = key.dataType();
        if (datatype.equals(Object.class)) {
            if (!this.attributeHandler.validDataType(attribute.getClass())) {
                throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)attribute);
            }
            return attribute;
        }
        if (!attribute.getClass().equals(datatype)) {
            Object converted = null;
            try {
                converted = this.attributeHandler.convert(datatype, attribute);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (converted == null) {
                throw new SchemaViolationException("Value [%s] is not an instance of the expected data type for property key [%s] and cannot be converted. Expected: %s, found: %s", attribute, key.name(), datatype, attribute.getClass());
            }
            attribute = converted;
        }
        assert (attribute.getClass().equals(datatype));
        this.attributeHandler.verifyAttribute(datatype, attribute);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelation(InternalRelation relation) {
        int i;
        Preconditions.checkArgument((!relation.isRemoved() ? 1 : 0) != 0);
        relation = relation.it();
        for (i = 0; i < relation.getLen(); ++i) {
            this.verifyWriteAccess(relation.getVertex(i));
        }
        for (i = 0; i < relation.getLen(); ++i) {
            relation.getVertex(i).removeRelation(relation);
        }
        if (relation.isNew()) {
            this.addedRelations.remove(relation);
            if (TypeUtil.hasSimpleInternalVertexKeyIndex(relation)) {
                this.newVertexIndexEntries.remove((JanusGraphVertexProperty)((Object)relation));
            }
        } else {
            Preconditions.checkArgument((boolean)relation.isLoaded());
            if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                if (this.config.isSingleThreaded()) {
                    this.deletedRelations = new HashMap<Long, InternalRelation>();
                } else {
                    StandardJanusGraphTx standardJanusGraphTx = this;
                    synchronized (standardJanusGraphTx) {
                        if (this.deletedRelations == EMPTY_DELETED_RELATIONS) {
                            this.deletedRelations = new ConcurrentHashMap<Long, InternalRelation>();
                        }
                    }
                }
            }
            this.deletedRelations.put(relation.longId(), relation);
        }
    }

    public boolean isRemovedRelation(Long relationId) {
        return this.deletedRelations.containsKey(relationId);
    }

    private TransactionLock getLock(Object ... tuple) {
        return this.getLock(new LockTuple(tuple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionLock getLock(LockTuple la) {
        ReentrantTransactionLock lock;
        TransactionLock existingLock;
        if (this.config.isSingleThreaded()) {
            return FakeLock.INSTANCE;
        }
        if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
            Preconditions.checkArgument((!this.config.isSingleThreaded() ? 1 : 0) != 0);
            StandardJanusGraphTx standardJanusGraphTx = this;
            synchronized (standardJanusGraphTx) {
                if (this.uniqueLocks == UNINITIALIZED_LOCKS) {
                    this.uniqueLocks = new ConcurrentHashMap<LockTuple, TransactionLock>();
                }
            }
        }
        return (existingLock = this.uniqueLocks.putIfAbsent(la, lock = new ReentrantTransactionLock())) == null ? lock : existingLock;
    }

    private TransactionLock getUniquenessLock(JanusGraphVertex out, InternalRelationType type, Object in) {
        Multiplicity multiplicity = type.multiplicity();
        TransactionLock uniqueLock = FakeLock.INSTANCE;
        if (this.config.hasVerifyUniqueness() && multiplicity.isConstrained()) {
            uniqueLock = null;
            if (multiplicity == Multiplicity.SIMPLE) {
                uniqueLock = this.getLock(out, type, in);
            } else {
                for (Direction dir : Direction.proper) {
                    if (!multiplicity.isUnique(dir)) continue;
                    TransactionLock lock = this.getLock(dir == Direction.OUT ? out : in, type, dir);
                    uniqueLock = uniqueLock == null ? lock : new CombinerLock(uniqueLock, lock, this.times);
                }
            }
        }
        assert (uniqueLock != null);
        return uniqueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JanusGraphEdge addEdge(JanusGraphVertex outVertex, JanusGraphVertex inVertex, EdgeLabel label) {
        this.verifyWriteAccess(outVertex, inVertex);
        outVertex = ((InternalVertex)outVertex).it();
        inVertex = ((InternalVertex)inVertex).it();
        Preconditions.checkNotNull((Object)label);
        Multiplicity multiplicity = label.multiplicity();
        TransactionLock uniqueLock = this.getUniquenessLock(outVertex, (InternalRelationType)((Object)label), inVertex);
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (multiplicity == Multiplicity.SIMPLE && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).adjacent(inVertex)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists between the pair of vertices and the label [%s] is simple", label.name());
                }
                if (multiplicity.isUnique(Direction.OUT) && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists on the out-vertex and the label [%s] is out-unique", label.name());
                }
                if (multiplicity.isUnique(Direction.IN) && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(inVertex).type(label)).direction(Direction.IN)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists on the in-vertex and the label [%s] is in-unique", label.name());
                }
            }
            StandardEdge edge = new StandardEdge(IDManager.getTemporaryRelationID(this.temporaryIds.nextID()), label, (InternalVertex)outVertex, (InternalVertex)inVertex, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(edge);
            }
            this.connectRelation(edge);
            StandardEdge standardEdge = edge;
            return standardEdge;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    private void connectRelation(InternalRelation r) {
        for (int i = 0; i < r.getLen(); ++i) {
            boolean success = r.getVertex(i).addRelation(r);
            if (!success) {
                throw new AssertionError((Object)("Could not connect relation: " + r));
            }
        }
        this.addedRelations.add(r);
        for (int pos = 0; pos < r.getLen(); ++pos) {
            this.vertexCache.add(r.getVertex(pos), r.getVertex(pos).longId());
        }
        if (TypeUtil.hasSimpleInternalVertexKeyIndex(r)) {
            this.newVertexIndexEntries.add((JanusGraphVertexProperty)((Object)r));
        }
    }

    public JanusGraphVertexProperty addProperty(JanusGraphVertex vertex, PropertyKey key, Object value) {
        return this.addProperty(key.cardinality().convert(), vertex, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JanusGraphVertexProperty addProperty(VertexProperty.Cardinality cardi, JanusGraphVertex vertex, PropertyKey key, Object value) {
        if (key.cardinality().convert() != cardi && cardi != VertexProperty.Cardinality.single) {
            throw new SchemaViolationException(String.format("Key is defined for %s cardinality which conflicts with specified: %s", new Object[]{key.cardinality(), cardi}));
        }
        this.verifyWriteAccess(vertex);
        Preconditions.checkArgument((!(key instanceof ImplicitKey) ? 1 : 0) != 0, (String)"Cannot create a property of implicit type: %s", (Object[])new Object[]{key.name()});
        vertex = ((InternalVertex)vertex).it();
        Preconditions.checkNotNull((Object)key);
        Object normalizedValue = this.verifyAttribute(key, value);
        Cardinality cardinality = key.cardinality();
        ArrayList<IndexLockTuple> uniqueIndexTuples = new ArrayList<IndexLockTuple>();
        for (CompositeIndexType compositeIndexType : TypeUtil.getUniqueIndexes(key)) {
            IndexSerializer.IndexRecords matches = IndexSerializer.indexMatches(vertex, compositeIndexType, key, normalizedValue);
            for (Object[] match : matches.getRecordValues()) {
                uniqueIndexTuples.add(new IndexLockTuple(compositeIndexType, match));
            }
        }
        TransactionLock uniqueLock = this.getUniquenessLock(vertex, (InternalRelationType)((Object)key), normalizedValue);
        for (IndexLockTuple lockTuple : uniqueIndexTuples) {
            uniqueLock = new CombinerLock(uniqueLock, this.getLock(lockTuple), this.times);
        }
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            if (cardi == VertexProperty.Cardinality.single || cardi == VertexProperty.Cardinality.set) {
                void var9_13;
                if (cardi == VertexProperty.Cardinality.single) {
                    Consumer<JanusGraphRelation> consumer = p -> p.remove();
                } else {
                    Consumer<JanusGraphRelation> consumer = p -> {
                        if (((JanusGraphVertexProperty)p).value().equals(normalizedValue)) {
                            p.remove();
                        }
                    };
                }
                if (!(this.config.hasVerifyUniqueness() && ((InternalRelationType)((Object)key)).getConsistencyModifier() == ConsistencyModifier.LOCK || TypeUtil.hasAnyIndex(key) || cardi != cardinality.convert())) {
                    ((InternalVertex)vertex).getAddedRelations((Predicate<InternalRelation>)((Predicate)p -> p.getType().equals(key))).forEach(var9_13);
                } else {
                    ((VertexCentricQueryBuilder)((InternalVertex)vertex).query().types(key)).properties().forEach((Consumer<JanusGraphVertexProperty>)var9_13);
                }
            }
            if (this.config.hasVerifyUniqueness()) {
                for (IndexLockTuple lockTuple : uniqueIndexTuples) {
                    if (Iterables.isEmpty(IndexHelper.getQueryResults(lockTuple.getIndex(), lockTuple.getAll(), this))) continue;
                    throw new SchemaViolationException("Adding this property for key [%s] and value [%s] violates a uniqueness constraint [%s]", key.name(), normalizedValue, lockTuple.getIndex());
                }
            }
            StandardVertexProperty standardVertexProperty = new StandardVertexProperty(IDManager.getTemporaryRelationID(this.temporaryIds.nextID()), key, (InternalVertex)vertex, normalizedValue, 1);
            if (this.config.hasAssignIDsImmediately()) {
                this.graph.assignID(standardVertexProperty);
            }
            this.connectRelation(standardVertexProperty);
            StandardVertexProperty standardVertexProperty2 = standardVertexProperty;
            return standardVertexProperty2;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    @Override
    public Iterable<JanusGraphEdge> getEdges(RelationIdentifier ... ids) {
        this.verifyOpen();
        if (ids == null || ids.length == 0) {
            return new VertexCentricEdgeIterable<JanusGraphEdge>(this.getInternalVertices(), RelationCategory.EDGE);
        }
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getEdgesByID").inc();
        }
        ArrayList<JanusGraphEdge> result = new ArrayList<JanusGraphEdge>(ids.length);
        for (RelationIdentifier id : ids) {
            JanusGraphEdge edge;
            if (id == null || (edge = id.findEdge(this)) == null || edge.isRemoved()) continue;
            result.add(edge);
        }
        return result;
    }

    public final JanusGraphSchemaVertex makeSchemaVertex(JanusGraphSchemaCategory schemaCategory, String name, TypeDefinitionMap definition) {
        JanusGraphSchemaVertex schemaVertex;
        this.verifyOpen();
        Preconditions.checkArgument((!schemaCategory.hasName() || StringUtils.isNotBlank((String)name) ? 1 : 0) != 0, (String)"Need to provide a valid name for type [%s]", (Object[])new Object[]{schemaCategory});
        schemaCategory.verifyValidDefinition(definition);
        if (schemaCategory.isRelationType()) {
            if (schemaCategory == JanusGraphSchemaCategory.PROPERTYKEY) {
                schemaVertex = new PropertyKeyVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserPropertyKey, this.temporaryIds.nextID()), 1);
            } else {
                assert (schemaCategory == JanusGraphSchemaCategory.EDGELABEL);
                schemaVertex = new EdgeLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserEdgeLabel, this.temporaryIds.nextID()), 1);
            }
        } else {
            schemaVertex = schemaCategory == JanusGraphSchemaCategory.VERTEXLABEL ? new VertexLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1) : new JanusGraphSchemaVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1);
        }
        this.graph.assignID(schemaVertex, BaseVertexLabel.DEFAULT_VERTEXLABEL);
        Preconditions.checkArgument((schemaVertex.longId() > 0L ? 1 : 0) != 0);
        if (schemaCategory.hasName()) {
            this.addProperty(schemaVertex, BaseKey.SchemaName, schemaCategory.getSchemaName(name));
        }
        this.addProperty(schemaVertex, BaseKey.VertexExists, Boolean.TRUE);
        this.addProperty(schemaVertex, BaseKey.SchemaCategory, (Object)schemaCategory);
        this.updateSchemaVertex(schemaVertex);
        this.addProperty(schemaVertex, BaseKey.SchemaUpdateTime, this.times.getTime(this.times.getTime()));
        for (Map.Entry def : definition.entrySet()) {
            JanusGraphVertexProperty p = this.addProperty(schemaVertex, BaseKey.SchemaDefinitionProperty, def.getValue());
            p.property(BaseKey.SchemaDefinitionDesc.name(), TypeDefinitionDescription.of((TypeDefinitionCategory)((Object)def.getKey())));
        }
        this.vertexCache.add(schemaVertex, schemaVertex.longId());
        if (schemaCategory.hasName()) {
            this.newTypeCache.put(schemaCategory.getSchemaName(name), schemaVertex.longId());
        }
        return schemaVertex;
    }

    public void updateSchemaVertex(JanusGraphSchemaVertex schemaVertex) {
        this.addProperty(VertexProperty.Cardinality.single, schemaVertex, BaseKey.SchemaUpdateTime, this.times.getTime(this.times.getTime()));
    }

    public PropertyKey makePropertyKey(String name, TypeDefinitionMap definition) {
        return (PropertyKey)((Object)this.makeSchemaVertex(JanusGraphSchemaCategory.PROPERTYKEY, name, definition));
    }

    public EdgeLabel makeEdgeLabel(String name, TypeDefinitionMap definition) {
        return (EdgeLabel)((Object)this.makeSchemaVertex(JanusGraphSchemaCategory.EDGELABEL, name, definition));
    }

    public JanusGraphSchemaVertex getSchemaVertex(String schemaName) {
        Long schemaId = this.newTypeCache.get(schemaName);
        if (schemaId == null) {
            schemaId = this.graph.getSchemaCache().getSchemaId(schemaName);
        }
        if (schemaId != null) {
            InternalVertex typeVertex = this.vertexCache.get(schemaId, this.existingVertexRetriever);
            assert (typeVertex != null);
            return (JanusGraphSchemaVertex)typeVertex;
        }
        return null;
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.getRelationType(name) != null;
    }

    @Override
    public RelationType getRelationType(String name) {
        this.verifyOpen();
        SystemRelationType type = SystemTypeManager.getSystemType(name);
        if (type != null) {
            return type;
        }
        return (RelationType)((Object)this.getSchemaVertex(JanusGraphSchemaCategory.getRelationTypeName(name)));
    }

    @Override
    public boolean containsPropertyKey(String name) {
        RelationType type = this.getRelationType(name);
        return type != null && type.isPropertyKey();
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        RelationType type = this.getRelationType(name);
        return type != null && type.isEdgeLabel();
    }

    @Override
    public RelationType getExistingRelationType(long typeid) {
        assert (this.idInspector.isRelationTypeId(typeid));
        if (IDManager.isSystemRelationTypeId(typeid)) {
            return SystemTypeManager.getSystemType(typeid);
        }
        InternalVertex v = this.getInternalVertex(typeid);
        return (RelationType)((Object)v);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        RelationType pk = this.getRelationType(name);
        Preconditions.checkArgument((pk == null || pk.isPropertyKey() ? 1 : 0) != 0, (String)"The relation type with name [%s] is not a property key", (Object[])new Object[]{name});
        return (PropertyKey)pk;
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makePropertyKey(this.makePropertyKey(name));
        }
        if (et.isPropertyKey()) {
            return (PropertyKey)et;
        }
        throw new IllegalArgumentException("The type of given name is not a key: " + name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        RelationType el = this.getRelationType(name);
        Preconditions.checkArgument((el == null || el.isEdgeLabel() ? 1 : 0) != 0, (String)"The relation type with name [%s] is not an edge label", (Object[])new Object[]{name});
        return (EdgeLabel)el;
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makeEdgeLabel(this.makeEdgeLabel(name));
        }
        if (et.isEdgeLabel()) {
            return (EdgeLabel)et;
        }
        throw new IllegalArgumentException("The type of given name is not a label: " + name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        StandardPropertyKeyMaker maker = new StandardPropertyKeyMaker(this, name, this.indexSerializer, this.attributeHandler);
        return maker;
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        StandardEdgeLabelMaker maker = new StandardEdgeLabelMaker(this, name, this.indexSerializer, this.attributeHandler);
        return maker;
    }

    @Override
    public VertexLabel getExistingVertexLabel(long id) {
        assert (this.idInspector.isVertexLabelVertexId(id));
        InternalVertex v = this.getInternalVertex(id);
        return (VertexLabelVertex)v;
    }

    @Override
    public boolean containsVertexLabel(String name) {
        this.verifyOpen();
        if (BaseVertexLabel.DEFAULT_VERTEXLABEL.name().equals(name)) {
            return true;
        }
        return this.getSchemaVertex(JanusGraphSchemaCategory.VERTEXLABEL.getSchemaName(name)) != null;
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        this.verifyOpen();
        if (BaseVertexLabel.DEFAULT_VERTEXLABEL.name().equals(name)) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabel)((Object)this.getSchemaVertex(JanusGraphSchemaCategory.VERTEXLABEL.getSchemaName(name)));
    }

    @Override
    public VertexLabel getOrCreateVertexLabel(String name) {
        VertexLabel vlabel = this.getVertexLabel(name);
        if (vlabel == null) {
            vlabel = this.config.getAutoSchemaMaker().makeVertexLabel(this.makeVertexLabel(name));
        }
        return vlabel;
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        StandardVertexLabelMaker maker = new StandardVertexLabelMaker(this);
        maker.name(name);
        return maker;
    }

    public VertexCentricQueryBuilder query(JanusGraphVertex vertex) {
        return new VertexCentricQueryBuilder(((InternalVertex)vertex).it());
    }

    @Deprecated
    public JanusGraphMultiVertexQuery multiQuery(JanusGraphVertex ... vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this);
        for (JanusGraphVertex v : vertices) {
            builder.addVertex(v);
        }
        return builder;
    }

    @Deprecated
    public JanusGraphMultiVertexQuery multiQuery(Collection<JanusGraphVertex> vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this);
        builder.addAllVertices(vertices);
        return builder;
    }

    public void executeMultiQuery(Collection<InternalVertex> vertices, SliceQuery sq, QueryProfiler profiler) {
        LongArrayList vids = new LongArrayList(vertices.size());
        for (InternalVertex v : vertices) {
            if (v.isNew() || !v.hasId() || !(v instanceof CacheVertex) || v.hasLoadedRelations(sq)) continue;
            vids.add(v.longId());
        }
        if (!vids.isEmpty()) {
            List results = QueryProfiler.profile(profiler, sq, true, q -> this.graph.edgeMultiQuery(vids, (SliceQuery)q, this.txHandle));
            int pos = 0;
            for (JanusGraphVertex janusGraphVertex : vertices) {
                if (pos >= vids.size() || vids.get(pos) != janusGraphVertex.longId()) continue;
                final EntryList vresults = (EntryList)results.get(pos);
                ((CacheVertex)janusGraphVertex).loadRelations(sq, new Retriever<SliceQuery, EntryList>(){

                    @Override
                    public EntryList get(SliceQuery query) {
                        return vresults;
                    }
                });
                ++pos;
            }
        }
    }

    public Function<Object, ? extends JanusGraphElement> getConversionFunction(ElementCategory elementCategory) {
        switch (elementCategory) {
            case VERTEX: {
                return this.vertexIDConversionFct;
            }
            case EDGE: {
                return this.edgeIDConversionFct;
            }
            case PROPERTY: {
                return this.propertyIDConversionFct;
            }
        }
        throw new IllegalArgumentException("Unexpected result type: " + (Object)((Object)elementCategory));
    }

    public GraphCentricQueryBuilder query() {
        return new GraphCentricQueryBuilder(this, this.graph.getIndexSerializer());
    }

    @Override
    public JanusGraphIndexQuery indexQuery(String indexName, String query) {
        return new IndexQueryBuilder(this, this.indexSerializer).setIndex(indexName).setQuery(query);
    }

    @Override
    public synchronized void commit() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit").inc();
        }
        try {
            if (this.hasModifications()) {
                this.graph.commit(this.addedRelations.getAll(), this.deletedRelations.values(), this);
            } else {
                this.txHandle.commit();
            }
            success = true;
            this.releaseTransaction();
        }
        catch (Exception e) {
            try {
                try {
                    this.txHandle.rollback();
                }
                catch (BackendException e1) {
                    throw new JanusGraphException("Could not rollback after a failed commit", e);
                }
                throw new JanusGraphException("Could not commit transaction due to exception during persistence", e);
            }
            catch (Throwable throwable) {
                this.releaseTransaction();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
        }
    }

    @Override
    public synchronized void rollback() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback").inc();
        }
        try {
            this.txHandle.rollback();
            success = true;
            this.releaseTransaction();
        }
        catch (Exception e) {
            try {
                throw new JanusGraphException("Could not rollback transaction due to exception", e);
            }
            catch (Throwable throwable) {
                this.releaseTransaction();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
        }
    }

    private void releaseTransaction() {
        this.isOpen = false;
        this.graph.closeTransaction(this);
        this.vertexCache.close();
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public boolean hasModifications() {
        return !this.addedRelations.isEmpty() || !this.deletedRelations.isEmpty();
    }

    private class VertexConstructor
    implements Retriever<Long, InternalVertex> {
        private final boolean verifyExistence;
        private final boolean createStubVertex;

        private VertexConstructor(boolean verifyExistence, boolean createStubVertex) {
            this.verifyExistence = verifyExistence;
            this.createStubVertex = createStubVertex;
        }

        public boolean hasVerifyExistence() {
            return this.verifyExistence;
        }

        @Override
        public InternalVertex get(Long vertexid) {
            long canonicalVertexId;
            Preconditions.checkArgument((vertexid != null && vertexid > 0L ? 1 : 0) != 0, (String)"Invalid vertex id: %s", (Object[])new Object[]{vertexid});
            Preconditions.checkArgument((StandardJanusGraphTx.this.idInspector.isSchemaVertexId(vertexid) || StandardJanusGraphTx.this.idInspector.isUserVertexId(vertexid) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object[])new Object[]{vertexid});
            byte lifecycle = 2;
            long l = canonicalVertexId = StandardJanusGraphTx.this.idInspector.isPartitionedVertex(vertexid) ? StandardJanusGraphTx.this.idManager.getCanonicalVertexId(vertexid) : vertexid.longValue();
            if (this.verifyExistence && StandardJanusGraphTx.this.graph.edgeQuery(canonicalVertexId, ((StandardJanusGraphTx)StandardJanusGraphTx.this).graph.vertexExistenceQuery, StandardJanusGraphTx.this.txHandle).isEmpty()) {
                lifecycle = 6;
            }
            if (canonicalVertexId != vertexid) {
                lifecycle = StandardJanusGraphTx.this.getExistingVertex(canonicalVertexId).getLifeCycle();
            }
            InternalVertex vertex = null;
            if (StandardJanusGraphTx.this.idInspector.isRelationTypeId(vertexid)) {
                if (StandardJanusGraphTx.this.idInspector.isPropertyKeyId(vertexid)) {
                    vertex = IDManager.isSystemRelationTypeId(vertexid) ? SystemTypeManager.getSystemType(vertexid) : new PropertyKeyVertex(StandardJanusGraphTx.this, vertexid, lifecycle);
                } else {
                    assert (StandardJanusGraphTx.this.idInspector.isEdgeLabelId(vertexid));
                    vertex = IDManager.isSystemRelationTypeId(vertexid) ? SystemTypeManager.getSystemType(vertexid) : new EdgeLabelVertex(StandardJanusGraphTx.this, vertexid, lifecycle);
                }
            } else if (StandardJanusGraphTx.this.idInspector.isVertexLabelVertexId(vertexid)) {
                vertex = new VertexLabelVertex(StandardJanusGraphTx.this, vertexid, lifecycle);
            } else if (StandardJanusGraphTx.this.idInspector.isGenericSchemaVertexId(vertexid)) {
                vertex = new JanusGraphSchemaVertex(StandardJanusGraphTx.this, vertexid, lifecycle);
            } else if (StandardJanusGraphTx.this.idInspector.isUserVertexId(vertexid)) {
                vertex = this.createStubVertex ? new PreloadedVertex(StandardJanusGraphTx.this, vertexid, lifecycle) : new CacheVertex(StandardJanusGraphTx.this, vertexid, lifecycle);
            } else {
                throw new IllegalArgumentException("ID could not be recognized");
            }
            return vertex;
        }
    }
}

