/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.lock;

import com.google.common.base.Preconditions;
import java.time.Duration;
import org.janusgraph.diskstorage.util.time.Timer;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.transaction.lock.TransactionLock;

public class CombinerLock
implements TransactionLock {
    private final TransactionLock first;
    private final TransactionLock second;
    private final TimestampProvider times;

    public CombinerLock(TransactionLock first, TransactionLock second, TimestampProvider times) {
        this.first = first;
        this.second = second;
        this.times = times;
        Preconditions.checkNotNull((Object)this.first);
        Preconditions.checkNotNull((Object)this.second);
        Preconditions.checkNotNull((Object)this.times);
    }

    @Override
    public void lock(Duration timeout) {
        Timer t = this.times.getTimer().start();
        this.first.lock(timeout);
        Duration remainingTimeout = timeout.minus(t.elapsed());
        try {
            this.second.lock(remainingTimeout);
        }
        catch (RuntimeException e) {
            this.first.unlock();
            throw e;
        }
    }

    @Override
    public void unlock() {
        try {
            this.first.unlock();
        }
        finally {
            this.second.unlock();
        }
    }

    @Override
    public boolean inUse() {
        return this.first.inUse() || this.second.inUse();
    }
}

