/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.relations.RelationIdentifier;

public class ElementHelper {
    public static Iterable<Object> getValues(JanusGraphElement element, PropertyKey key) {
        if (element instanceof JanusGraphRelation) {
            Object value = element.valueOrNull(key);
            if (value == null) {
                return Collections.EMPTY_LIST;
            }
            return ImmutableList.of(value);
        }
        assert (element instanceof JanusGraphVertex);
        return Iterables.transform(((JanusGraphVertex)element).query().keys(new String[]{key.name()}).properties(), (Function)new Function<JanusGraphVertexProperty, Object>(){

            @Nullable
            public Object apply(@Nullable JanusGraphVertexProperty janusgraphProperty) {
                return janusgraphProperty.value();
            }
        });
    }

    public static long getCompareId(Element element) {
        Object id = element.id();
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof RelationIdentifier) {
            return ((RelationIdentifier)id).getRelationId();
        }
        throw new IllegalArgumentException("Element identifier has unrecognized type: " + id);
    }

    public static void attachProperties(JanusGraphRelation element, Object ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return;
        }
        org.apache.tinkerpop.gremlin.structure.util.ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (org.apache.tinkerpop.gremlin.structure.util.ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        if (org.apache.tinkerpop.gremlin.structure.util.ElementHelper.getLabelValue((Object[])keyValues).isPresent()) {
            throw new IllegalArgumentException("Cannot provide label as argument");
        }
        org.apache.tinkerpop.gremlin.structure.util.ElementHelper.attachProperties((Element)element, (Object[])keyValues);
    }

    public static void attachProperties(JanusGraphVertex vertex, Object ... propertyKeyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals(T.id) || propertyKeyValues[i].equals(T.label)) continue;
            vertex.property((String)propertyKeyValues[i], propertyKeyValues[i + 1]);
        }
    }

    public static Set<String> getPropertyKeys(JanusGraphVertex v) {
        HashSet<String> s = new HashSet<String>();
        v.query().properties().forEach(p -> s.add(p.propertyKey().name()));
        return s;
    }
}

