/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class IndexHelper {
    public static Iterable<? extends Element> getQueryResults(CompositeIndexType index, Object[] values, StandardJanusGraphTx tx) {
        GraphCentricQueryBuilder gb = IndexHelper.getQuery(index, values, tx);
        switch (index.getElement()) {
            case VERTEX: {
                return gb.vertices();
            }
            case EDGE: {
                return gb.edges();
            }
            case PROPERTY: {
                return gb.properties();
            }
        }
        throw new AssertionError();
    }

    public static GraphCentricQueryBuilder getQuery(CompositeIndexType index, Object[] values, StandardJanusGraphTx tx) {
        Preconditions.checkArgument((index != null && values != null && values.length > 0 && tx != null ? 1 : 0) != 0);
        Preconditions.checkArgument((values.length == index.getFieldKeys().length ? 1 : 0) != 0);
        GraphCentricQueryBuilder gb = tx.query();
        IndexField[] fields = index.getFieldKeys();
        for (int i = 0; i < fields.length; ++i) {
            IndexField f = fields[i];
            Object value = values[i];
            Preconditions.checkNotNull((Object)value);
            PropertyKey key = f.getFieldKey();
            Preconditions.checkArgument((boolean)key.dataType().equals(value.getClass()), (Object)("Incompatible data types for: " + value));
            gb.has(key, (JanusGraphPredicate)Cmp.EQUAL, value);
        }
        if (index.hasSchemaTypeConstraint()) {
            gb.has(ImplicitKey.LABEL, (JanusGraphPredicate)Cmp.EQUAL, (Object)index.getSchemaTypeConstraint().name());
        }
        return gb;
    }
}

