/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkerPool
implements AutoCloseable {
    private final ThreadPoolExecutor processor;
    private final long shutdownWaitMS = 10000L;

    public WorkerPool(int numThreads) {
        this.processor = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(128));
        this.processor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void submit(Runnable runnable) {
        this.processor.submit(runnable);
    }

    @Override
    public void close() throws Exception {
        this.processor.shutdown();
        this.processor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        if (!this.processor.isTerminated()) {
            this.processor.shutdownNow();
        }
    }
}

