/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class IterablesUtil {
    public static final Predicate NO_FILTER = new NoFilter();

    public static final <O> Iterable<O> emptyIterable() {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return Iterators.emptyIterator();
            }
        };
    }

    public static final <E> Predicate<E> noFilter() {
        return NO_FILTER;
    }

    public static final <O> Iterable<O> limitedIterable(Iterable<O> iterable, final int limit) {
        return Iterables.filter(iterable, (Predicate)new Predicate<O>(){
            int count = 0;

            public boolean apply(@Nullable O o) {
                ++this.count;
                return this.count <= limit;
            }
        });
    }

    public static final int size(Iterable i) {
        if (i instanceof Collection) {
            return ((Collection)i).size();
        }
        return Iterables.size((Iterable)i);
    }

    public static final boolean sizeLargerOrEqualThan(Iterable i, int limit) {
        if (i instanceof Collection) {
            return ((Collection)i).size() >= limit;
        }
        Iterator iter = i.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            if (++count < limit) continue;
            return true;
        }
        return false;
    }

    public static <E> List<E> mergeSort(Collection<E> a, Collection<E> b, Comparator<E> comp) {
        Iterator<E> itera = a.iterator();
        Iterator<E> iterb = b.iterator();
        Object heada = itera.hasNext() ? itera.next() : null;
        Object headb = iterb.hasNext() ? iterb.next() : null;
        ArrayList<Object> result = new ArrayList<Object>(a.size() + b.size());
        while (heada != null || headb != null) {
            Object next;
            if (heada == null) {
                next = headb;
                headb = null;
            } else if (headb == null) {
                next = heada;
                heada = null;
            } else if (comp.compare(heada, headb) <= 0) {
                next = heada;
                heada = null;
            } else {
                next = headb;
                headb = null;
            }
            assert (next != null);
            Preconditions.checkArgument((result.isEmpty() || comp.compare(result.get(result.size() - 1), next) <= 0 ? 1 : 0) != 0, (Object)"The input collections are not sorted");
            result.add(next);
            if (heada == null) {
                Object v0 = heada = itera.hasNext() ? itera.next() : null;
            }
            if (headb != null) continue;
            headb = iterb.hasNext() ? iterb.next() : null;
        }
        return result;
    }

    private static class NoFilter<E>
    implements Predicate<E> {
        private NoFilter() {
        }

        public boolean apply(@Nullable E e) {
            return true;
        }
    }
}

