/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.ConfigurationLint;
import org.janusgraph.util.system.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFileFilter {
    private static final Pattern REPLACEMENT_PATTERN = Pattern.compile("^#JANUSGRAPHCFG\\{((.+)=(.*))\\}$");
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFileFilter.class);
    private static final int WRAP_COLUMNS = 72;

    public static void main(String[] args) throws IOException {
        int errors = ConfigurationFileFilter.filter(args[0], args[1]);
        System.exit(Math.min(errors, 127));
    }

    public static int filter(String inputContextDirPath, String outputContextDirPath) throws IOException {
        InputRecord rec;
        File inputContextDir = new File(inputContextDirPath);
        File outputContextDir = new File(outputContextDirPath);
        log.info("Input context dir:  {}", (Object)inputContextDir);
        log.info("Output context dir: {}", (Object)outputContextDir);
        Preconditions.checkArgument((boolean)inputContextDir.isDirectory(), (String)"Input context dir %s is not a directory", (Object[])new Object[]{inputContextDir});
        Preconditions.checkArgument((boolean)inputContextDir.canRead(), (String)"Input context dir %s is not readable", (Object[])new Object[]{inputContextDir});
        if (!outputContextDir.exists()) {
            outputContextDir.mkdirs();
        }
        LinkedList<InputRecord> dirQueue = new LinkedList<InputRecord>();
        dirQueue.add(new InputRecord(inputContextDir, File.separator));
        int parseErrors = 0;
        int visitedDirs = 0;
        int processedFiles = 0;
        while (null != (rec = (InputRecord)dirQueue.poll())) {
            File curDir = rec.getDirectory();
            String contextPath = rec.getContextPath();
            Preconditions.checkState((boolean)curDir.exists());
            Preconditions.checkState((boolean)curDir.isDirectory());
            Preconditions.checkState((boolean)curDir.canRead());
            ++visitedDirs;
            for (File f : curDir.listFiles()) {
                if (f.isDirectory()) {
                    if (!f.canRead()) {
                        log.warn("Skipping unreadable directory {} in input basedir", (Object)f);
                        continue;
                    }
                    dirQueue.add(new InputRecord(f, contextPath + f.getName() + File.separator));
                    continue;
                }
                if (!f.canRead()) {
                    log.warn("Skipping unreadable file {} in input basedir", (Object)f);
                    continue;
                }
                File outputDir = new File(outputContextDir.getPath() + contextPath);
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                }
                parseErrors += ConfigurationFileFilter.processFile(f, new File(outputContextDir.getPath() + contextPath + f.getName()));
                ++processedFiles;
            }
        }
        String summaryTemplate = "Summary: visited {} dir(s) and processed {} file(s) with {} parse error(s).";
        if (0 == parseErrors) {
            log.info(summaryTemplate, new Object[]{visitedDirs, processedFiles, parseErrors});
        } else {
            log.error(summaryTemplate, new Object[]{visitedDirs, processedFiles, parseErrors});
        }
        return parseErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processFile(File inputFile, File outputFile) throws IOException {
        BufferedReader in = null;
        PrintStream out = null;
        int inputLines = 0;
        int replacements = 0;
        int parseErrors = 0;
        try {
            String line;
            in = new BufferedReader(new FileReader(inputFile));
            out = new PrintStream(outputFile);
            while (null != (line = in.readLine())) {
                ++inputLines;
                Matcher m = REPLACEMENT_PATTERN.matcher(line);
                if (m.matches()) {
                    String cfgKey = m.group(2).trim();
                    m.group(3);
                    try {
                        ConfigElement.PathIdentifier pid = ConfigElement.parse(GraphDatabaseConfiguration.ROOT_NS, cfgKey);
                        ConfigOption opt = (ConfigOption)pid.element;
                        String kvPair = m.group(1);
                        String descr = "# " + WordUtils.wrap((String)opt.getDescription(), (int)72, (String)"\n# ", (boolean)false);
                        String dt = "# Data Type:  ";
                        if (opt.getDatatype().isArray()) {
                            dt = dt + opt.getDatatype().getComponentType().toString() + "[]";
                        } else if (opt.getDatatype().isEnum()) {
                            Enum[] enums = (Enum[])opt.getDatatype().getEnumConstants();
                            Object[] names = new String[enums.length];
                            for (int i = 0; i < names.length; ++i) {
                                names[i] = enums[i].name();
                            }
                            dt = dt + opt.getDatatype().getSimpleName() + " enum:";
                            String s = "\n#             { " + Joiner.on((String)", ").join(names) + " }";
                            dt = dt + WordUtils.wrap((String)s, (int)72, (String)"\n#               ", (boolean)false);
                        } else {
                            dt = dt + opt.getDatatype().getSimpleName();
                        }
                        String defval = "# Default:    ";
                        defval = null == opt.getDefaultValue() ? defval + "(no default value)" : (opt.getDatatype().isArray() ? defval + Joiner.on((String)", ").join((Object[])opt.getDefaultValue()) : (opt.getDatatype().isEnum() ? defval + ((Enum)opt.getDefaultValue()).name() : defval + opt.getDefaultValue()));
                        String mut = "# Mutability: " + (Object)((Object)opt.getType());
                        if (opt.isManaged()) {
                            mut = mut + "\n#\n# ";
                            if (opt.getType().equals((Object)ConfigOption.Type.FIXED)) {
                                mut = mut + "This setting is " + (Object)((Object)opt.getType()) + " and cannot be changed after bootstrapping JanusGraph.";
                            } else {
                                String warning = "Settings with mutability " + (Object)((Object)opt.getType()) + " are centrally managed in " + "JanusGraph's storage backend.  After starting the database for the first time, " + "this file's copy of this setting is ignored.  Use JanusGraph's Management " + "System to read or modify this value after bootstrapping.";
                                mut = mut + WordUtils.wrap((String)warning, (int)72, (String)"\n# ", (boolean)false);
                            }
                        }
                        out.println(descr);
                        out.println("#");
                        out.println(defval);
                        out.println(dt);
                        out.println(mut);
                        out.println(kvPair);
                        ++replacements;
                    }
                    catch (RuntimeException e) {
                        out.println(line);
                        log.warn("Exception on {}:{}", new Object[]{inputFile, line, e});
                        ++parseErrors;
                    }
                    continue;
                }
                out.println(line);
            }
            log.info("Read {}: {} lines, {} macro substitutions", new Object[]{inputFile, inputLines, replacements});
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(in);
        ConfigurationLint.Status stat = ConfigurationLint.validate(outputFile.getAbsolutePath());
        if (0 != stat.getErrorSettingCount()) {
            log.error("Output file {} failed to validate", (Object)outputFile);
        }
        return parseErrors += stat.getErrorSettingCount();
    }

    private static class InputRecord {
        private final File directory;
        private final String contextPath;

        private InputRecord(File directory, String relativePath) {
            this.directory = directory;
            this.contextPath = relativePath;
        }

        public File getDirectory() {
            return this.directory;
        }

        public String getContextPath() {
            return this.contextPath;
        }
    }
}

