/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectReader;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectWriter;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.core.attribute.GeoshapeHelper;
import org.janusgraph.core.attribute.JtsGeoshapeHelper;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.util.ReadArrayBuffer;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class Geoshape {
    private static String FIELD_LABEL = "geometry";
    private static String FIELD_TYPE = "type";
    private static String FIELD_COORDINATES = "coordinates";
    public static final GeoshapeHelper HELPER;
    private static final ObjectReader mapReader;
    private static final ObjectWriter mapWriter;
    private final Shape shape;

    protected Geoshape(Shape shape) {
        Preconditions.checkNotNull((Object)shape, (Object)"Invalid shape (null)");
        this.shape = shape;
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        Geoshape oth = (Geoshape)other;
        return this.shape.equals((Object)oth.shape);
    }

    public String toString() {
        return HELPER.getWktWriter().toString(this.shape);
    }

    public String toGeoJson() {
        return GeoshapeGsonSerializerV1d0.toGeoJson(this);
    }

    public Map<String, Object> toMap() throws IOException {
        return (Map)mapReader.readValue(this.toGeoJson());
    }

    public Shape getShape() {
        return this.shape;
    }

    public Type getType() {
        return HELPER.getType(this.shape);
    }

    public int size() {
        return HELPER.size(this.shape);
    }

    public Point getPoint(int position) {
        return HELPER.getPoint(this, position);
    }

    public Point getPoint() {
        Preconditions.checkArgument((this.getType() == Type.POINT || this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"Shape does not have a single point");
        return new Point(this.shape.getCenter().getY(), this.shape.getCenter().getX());
    }

    public double getRadius() {
        Preconditions.checkArgument((this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"This shape is not a circle");
        double radiusInDeg = ((Circle)this.shape).getRadius();
        return DistanceUtils.degrees2Dist((double)radiusInDeg, (double)6371.0087714);
    }

    private SpatialRelation getSpatialRelation(Geoshape other) {
        Preconditions.checkNotNull((Object)other);
        return this.shape.relate(other.shape);
    }

    public boolean intersect(Geoshape other) {
        SpatialRelation r = this.getSpatialRelation(other);
        return r == SpatialRelation.INTERSECTS || r == SpatialRelation.CONTAINS || r == SpatialRelation.WITHIN;
    }

    public boolean within(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.WITHIN;
    }

    public boolean contains(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.CONTAINS;
    }

    public boolean disjoint(Geoshape other) {
        return this.getSpatialRelation(other) == SpatialRelation.DISJOINT;
    }

    public static final Geoshape point(double latitude, double longitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        return new Geoshape((Shape)Geoshape.getShapeFactory().pointXY(longitude, latitude));
    }

    public static final Geoshape circle(double latitude, double longitude, double radiusInKM) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        Preconditions.checkArgument((radiusInKM > 0.0 ? 1 : 0) != 0, (String)"Invalid radius provided [%s]", (Object[])new Object[]{radiusInKM});
        return new Geoshape((Shape)Geoshape.getShapeFactory().circle(longitude, latitude, DistanceUtils.dist2Degrees((double)radiusInKM, (double)6371.0087714)));
    }

    public static final Geoshape box(double southWestLatitude, double southWestLongitude, double northEastLatitude, double northEastLongitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(southWestLatitude, southWestLongitude), (Object)"Invalid south-west coordinate provided");
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(northEastLatitude, northEastLongitude), (Object)"Invalid north-east coordinate provided");
        return new Geoshape((Shape)Geoshape.getShapeFactory().rect(southWestLongitude, northEastLongitude, southWestLatitude, northEastLatitude));
    }

    public static final Geoshape line(List<double[]> coordinates) {
        Preconditions.checkArgument((coordinates.size() >= 2 ? 1 : 0) != 0, (Object)"Too few coordinate pairs provided");
        ShapeFactory.LineStringBuilder builder = Geoshape.getShapeFactory().lineString();
        for (double[] coordinate : coordinates) {
            Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(coordinate[1], coordinate[0]), (Object)"Invalid coordinate provided");
            builder.pointXY(coordinate[0], coordinate[1]);
        }
        return new Geoshape(builder.build());
    }

    public static final Geoshape polygon(List<double[]> coordinates) {
        return HELPER.polygon(coordinates);
    }

    public static final Geoshape geoshape(Shape shape) {
        return new Geoshape(shape);
    }

    public static final Geoshape fromWkt(String wkt) throws ParseException {
        return new Geoshape(HELPER.getWktReader().parse(wkt));
    }

    public static final boolean isValidCoordinate(double latitude, double longitude) {
        return latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0;
    }

    public static final SpatialContext getSpatialContext() {
        return HELPER.getContext();
    }

    public static final ShapeFactory getShapeFactory() {
        return Geoshape.getSpatialContext().getShapeFactory();
    }

    public static final ShapeFactory.MultiShapeBuilder<Shape> getGeometryCollectionBuilder() {
        return Geoshape.getShapeFactory().multiShape(Shape.class);
    }

    static {
        boolean haveJts = false;
        try {
            haveJts = Class.forName("com.vividsolutions.jts.geom.Geometry") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HELPER = haveJts ? new JtsGeoshapeHelper() : new GeoshapeHelper();
        ObjectMapper mapper = new ObjectMapper();
        mapReader = mapper.readerWithView(LinkedHashMap.class).forType(LinkedHashMap.class);
        mapWriter = mapper.writerWithView(Map.class);
    }

    public static class GeoshapeBinarySerializer {
        public static void write(OutputStream outputStream, Geoshape attribute) throws IOException {
            outputStream.write(HELPER.isJts(attribute.shape) ? 0 : 1);
            try (DataOutputStream dataOutput = new DataOutputStream(outputStream);){
                HELPER.write(dataOutput, attribute);
                dataOutput.flush();
            }
            outputStream.flush();
        }

        public static Geoshape read(InputStream inputStream) throws IOException {
            boolean isJts = inputStream.read() == 0;
            try (DataInputStream dataInput = new DataInputStream(inputStream);){
                if (isJts) {
                    Geoshape geoshape = new Geoshape(HELPER.readGeometry(dataInput));
                    return geoshape;
                }
                Geoshape geoshape = new Geoshape(HELPER.getBinaryCodec().readShape((DataInput)dataInput));
                return geoshape;
            }
        }
    }

    public static class GeoshapeGsonDeserializerV2d0
    extends AbstractObjectDeserializer<Geoshape> {
        public GeoshapeGsonDeserializerV2d0() {
            super(Geoshape.class);
        }

        public Geoshape createObject(Map<String, Object> data) {
            Geoshape shape;
            if (data.containsKey(FIELD_COORDINATES) && data.get(FIELD_COORDINATES) instanceof List) {
                List coordinates = (List)data.get(FIELD_COORDINATES);
                if (coordinates.size() < 2) {
                    throw new RuntimeException("Expecting two coordinates when reading point");
                }
                shape = Geoshape.point(((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(0)).doubleValue());
            } else {
                try {
                    String json = mapWriter.writeValueAsString(data.get("geometry"));
                    shape = new Geoshape(HELPER.getGeojsonReader().read((Reader)new StringReader(json)));
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException("I/O exception reading geoshape", e);
                }
            }
            return shape;
        }
    }

    public static class GeoshapeGsonSerializerV2d0
    extends GeoshapeGsonSerializerV1d0 {
        @Override
        public void serializeWithType(Geoshape geoshape, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@type", "janusgraph:Geoshape");
            }
            jgen.writeFieldName("@value");
            GraphSONUtil.writeStartObject((Object)geoshape, (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            Map json = (Map)mapReader.readValue(GeoshapeGsonSerializerV2d0.toGeoJson(geoshape));
            if (geoshape.getType() == Type.POINT) {
                double[] coords = ((List)json.get(FIELD_COORDINATES)).stream().mapToDouble(i -> i.doubleValue()).toArray();
                GraphSONUtil.writeWithType((String)FIELD_COORDINATES, (Object)coords, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            } else {
                GraphSONUtil.writeWithType((String)FIELD_LABEL, (Object)json, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            GraphSONUtil.writeEndObject((Object)geoshape, (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            jgen.writeEndObject();
        }

        public static String toGeoJson(Geoshape geoshape) {
            return HELPER.getGeojsonWriter().toString(geoshape.shape);
        }
    }

    public static class GeoshapeGsonDeserializerV1d0
    extends StdDeserializer<Geoshape> {
        public GeoshapeGsonDeserializerV1d0() {
            super(Geoshape.class);
        }

        public Geoshape deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            jsonParser.nextToken();
            if (jsonParser.getCurrentName().equals(FIELD_COORDINATES)) {
                double[] f = (double[])jsonParser.readValueAs(double[].class);
                jsonParser.nextToken();
                return Geoshape.point(f[1], f[0]);
            }
            try {
                HashMap map = (HashMap)jsonParser.readValueAs(LinkedHashMap.class);
                jsonParser.nextToken();
                String json = mapWriter.writeValueAsString((Object)map);
                Geoshape shape = new Geoshape(HELPER.getGeojsonReader().read((Reader)new StringReader(json)));
                return shape;
            }
            catch (ParseException e) {
                throw new IOException("Unable to read and parse geojson", e);
            }
        }
    }

    public static class GeoshapeGsonSerializerV1d0
    extends StdSerializer<Geoshape> {
        public GeoshapeGsonSerializerV1d0() {
            super(Geoshape.class);
        }

        public void serialize(Geoshape value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.getType()) {
                case POINT: {
                    jgen.writeStartObject();
                    jgen.writeFieldName(FIELD_TYPE);
                    jgen.writeString(Type.POINT.toString());
                    jgen.writeFieldName(FIELD_COORDINATES);
                    jgen.writeStartArray();
                    jgen.writeNumber(value.getPoint().getLongitude());
                    jgen.writeNumber(value.getPoint().getLatitude());
                    jgen.writeEndArray();
                    jgen.writeEndObject();
                    break;
                }
                default: {
                    jgen.writeRawValue(GeoshapeGsonSerializerV1d0.toGeoJson(value));
                }
            }
        }

        public void serializeWithType(Geoshape geoshape, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@class", Geoshape.class.getName());
            }
            String geojson = GeoshapeGsonSerializerV1d0.toGeoJson(geoshape);
            Map json = (Map)mapReader.readValue(geojson);
            if (geoshape.getType() == Type.POINT) {
                double[] coords = ((List)json.get(FIELD_COORDINATES)).stream().map(i -> i.doubleValue()).mapToDouble(i -> i).toArray();
                GraphSONUtil.writeWithType((String)FIELD_COORDINATES, (Object)coords, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            } else {
                GraphSONUtil.writeWithType((String)FIELD_LABEL, (Object)json, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            jgen.writeEndObject();
        }

        public static String toGeoJson(Geoshape geoshape) {
            return HELPER.getGeojsonWriter().toString(geoshape.shape);
        }
    }

    public static class GeoShapeGryoSerializer
    extends Serializer<Geoshape> {
        public void write(Kryo kryo, Output output, Geoshape geoshape) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                GeoshapeBinarySerializer.write((OutputStream)outputStream, geoshape);
                byte[] bytes = outputStream.toByteArray();
                output.writeLong((long)bytes.length);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception writing geoshape", e);
            }
        }

        public Geoshape read(Kryo kryo, Input input, Class<Geoshape> aClass) {
            long l = input.readLong();
            assert (l > 0L && l < Integer.MAX_VALUE);
            int length = (int)l;
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(input.readBytes(length));
                return GeoshapeBinarySerializer.read(inputStream);
            }
            catch (IOException | KryoException e) {
                try {
                    input.setPosition(0);
                    input.readLong();
                    float lat = input.readFloat();
                    float lon = input.readFloat();
                    return Geoshape.point(lat, lon);
                }
                catch (KryoException kryoException) {
                    throw new RuntimeException("I/O exception reading geoshape", e);
                }
            }
        }
    }

    public static class GeoshapeSerializer
    implements AttributeSerializer<Geoshape> {
        @Override
        public void verifyAttribute(Geoshape value) {
        }

        @Override
        public Geoshape convert(Object value) {
            if (value instanceof Map) {
                return this.convertGeoJson(value);
            }
            if (value instanceof Collection) {
                value = this.convertCollection((Collection)value);
            }
            if (value.getClass().isArray() && (value.getClass().getComponentType().isPrimitive() || Number.class.isAssignableFrom(value.getClass().getComponentType()))) {
                Geoshape shape = null;
                int len = Array.getLength(value);
                double[] arr = new double[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = ((Number)Array.get(value, i)).doubleValue();
                }
                if (len == 2) {
                    shape = Geoshape.point(arr[0], arr[1]);
                } else if (len == 3) {
                    shape = Geoshape.circle(arr[0], arr[1], arr[2]);
                } else if (len == 4) {
                    shape = Geoshape.box(arr[0], arr[1], arr[2], arr[3]);
                } else {
                    throw new IllegalArgumentException("Expected 2-4 coordinates to create Geoshape, but given: " + value);
                }
                return shape;
            }
            if (value instanceof String) {
                String delimiter;
                String[] components = null;
                String[] len = new String[]{",", ";"};
                int arr = len.length;
                for (int i = 0; i < arr && ((components = ((String)value).split(delimiter = len[i])).length < 2 || components.length > 4); ++i) {
                    components = null;
                }
                Preconditions.checkArgument((components != null ? 1 : 0) != 0, (String)"Could not parse coordinates from string: %s", (Object[])new Object[]{value});
                double[] coords = new double[components.length];
                try {
                    for (int i = 0; i < components.length; ++i) {
                        coords[i] = Double.parseDouble(components[i]);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse coordinates from string: " + value, e);
                }
                return this.convert(coords);
            }
            return null;
        }

        private double[] convertCollection(Collection<Object> c) {
            List numbers = c.stream().map(o -> {
                if (!(o instanceof Number)) {
                    throw new IllegalArgumentException("Collections may only contain numbers to create a Geoshape");
                }
                return ((Number)o).doubleValue();
            }).collect(Collectors.toList());
            return Doubles.toArray(numbers);
        }

        private Geoshape convertGeoJson(Object value) {
            try {
                Map map = (Map)value;
                String type = (String)map.get("type");
                if ("Feature".equals(type)) {
                    Map geometry = (Map)map.get("geometry");
                    return this.convertGeometry(geometry);
                }
                return this.convertGeometry(map);
            }
            catch (IOException | ClassCastException | ParseException e) {
                throw new IllegalArgumentException("GeoJSON was unparsable");
            }
        }

        private Geoshape convertGeometry(Map<String, Object> geometry) throws IOException, ParseException {
            String type = (String)geometry.get("type");
            List coordinates = (List)geometry.get(FIELD_COORDINATES);
            if ("Point".equals(type)) {
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.point(parsedCoordinates[1], parsedCoordinates[0]);
            }
            if ("Circle".equals(type)) {
                Number radius = (Number)geometry.get("radius");
                if (radius == null) {
                    throw new IllegalArgumentException("GeoJSON circles require a radius");
                }
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.circle(parsedCoordinates[1], parsedCoordinates[0], radius.doubleValue());
            }
            if ("Polygon".equals(type) && coordinates.size() == 4) {
                double[] p0 = this.convertCollection((Collection)coordinates.get(0));
                double[] p1 = this.convertCollection((Collection)coordinates.get(1));
                double[] p2 = this.convertCollection((Collection)coordinates.get(2));
                double[] p3 = this.convertCollection((Collection)coordinates.get(3));
                if (p0[0] == p1[0] && p1[1] == p2[1] && p2[0] == p3[0] && p3[1] == p0[1] && p3[0] != p0[0] || p0[1] == p1[1] && p1[0] == p2[0] && p2[1] == p3[1] && p3[0] == p0[0] && p3[1] != p0[1]) {
                    return Geoshape.box(this.min(p0[1], p1[1], p2[1], p3[1]), this.min(p0[0], p1[0], p2[0], p3[0]), this.max(p0[1], p1[1], p2[1], p3[1]), this.max(p0[0], p1[0], p2[0], p3[0]));
                }
            }
            String json = mapWriter.writeValueAsString(geometry);
            return new Geoshape(HELPER.getGeojsonReader().read((Reader)new StringReader(json)));
        }

        private double min(double ... numbers) {
            return Arrays.stream(numbers).min().getAsDouble();
        }

        private double max(double ... numbers) {
            return Arrays.stream(numbers).max().getAsDouble();
        }

        @Override
        public Geoshape read(ScanBuffer buffer) {
            long l = VariableLong.readPositive(buffer);
            assert (l > 0L && l < Integer.MAX_VALUE);
            int length = (int)l;
            int position = ((ReadArrayBuffer)buffer).getPosition();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.getBytes(length));
            try {
                return GeoshapeBinarySerializer.read(inputStream);
            }
            catch (IOException e) {
                try {
                    ((ReadArrayBuffer)buffer).movePositionTo(position);
                    float lat = buffer.getFloat();
                    float lon = buffer.getFloat();
                    return Geoshape.point(lat, lon);
                }
                catch (Exception exception) {
                    throw new RuntimeException("I/O exception reading geoshape", e);
                }
            }
        }

        @Override
        public void write(WriteBuffer buffer, Geoshape attribute) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                GeoshapeBinarySerializer.write((OutputStream)outputStream, attribute);
                byte[] bytes = outputStream.toByteArray();
                VariableLong.writePositive(buffer, bytes.length);
                buffer.putBytes(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception writing geoshape", e);
            }
        }
    }

    public static final class Point {
        private final double longitude;
        private final double latitude;

        Point(double latitude, double longitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        private org.locationtech.spatial4j.shape.Point getSpatial4jPoint() {
            return Geoshape.getShapeFactory().pointXY(this.longitude, this.latitude);
        }

        public double distance(Point other) {
            return DistanceUtils.degrees2Dist((double)HELPER.getContext().getDistCalc().distance(this.getSpatial4jPoint(), other.getSpatial4jPoint()), (double)6371.0087714);
        }
    }

    public static enum Type {
        POINT("Point"),
        BOX("Box"),
        CIRCLE("Circle"),
        LINE("Line"),
        POLYGON("Polygon"),
        MULTIPOINT("MultiPoint"),
        MULTILINESTRING("MultiLineString"),
        MULTIPOLYGON("MultiPolygon"),
        GEOMETRYCOLLECTION("GeometryCollection");

        private final String gsonName;

        private Type(String gsonName) {
            this.gsonName = gsonName;
        }

        public boolean gsonEquals(String otherGson) {
            return otherGson != null && this.gsonName.equals(otherGson);
        }

        public static Type fromGson(String gsonShape) {
            return Type.valueOf(gsonShape.toUpperCase());
        }

        public String toString() {
            return this.gsonName;
        }
    }
}

