/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.janusgraph.core.attribute.Geoshape;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.io.GeoJSONReader;
import org.locationtech.spatial4j.io.GeoJSONWriter;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.io.WKTWriter;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;

public class GeoshapeHelper {
    protected SpatialContext context;
    protected WKTReader wktReader;
    protected WKTWriter wktWriter;
    protected GeoJSONReader geojsonReader;
    protected GeoJSONWriter geojsonWriter;
    protected BinaryCodec binaryCodec;
    protected SpatialContextFactory factory = new SpatialContextFactory();

    public GeoshapeHelper() {
        this.factory.geo = true;
        this.context = new SpatialContext(this.factory);
        this.wktReader = new WKTReader(this.context, this.factory);
        this.wktWriter = new WKTWriter();
        this.geojsonReader = new GeoJSONReader(this.context, this.factory);
        this.geojsonWriter = new GeoJSONWriter(this.context, this.factory);
        this.binaryCodec = new BinaryCodec(this.context, this.factory);
    }

    public Shape readGeometry(DataInputStream dataInput) throws IOException {
        throw new UnsupportedOperationException("JTS is required for this operation");
    }

    public void write(DataOutputStream dataOutput, Geoshape attribute) throws IOException {
        this.binaryCodec.writeShape((DataOutput)dataOutput, attribute.getShape());
    }

    public Geoshape polygon(List<double[]> coordinates) {
        throw new UnsupportedOperationException("JTS is required for this operation");
    }

    public Geoshape.Type getType(Shape shape) {
        Geoshape.Type type;
        if (Point.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.POINT;
        } else if (Circle.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.CIRCLE;
        } else if (Rectangle.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.BOX;
        } else if (BufferedLineString.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.LINE;
        } else if (ShapeCollection.class.isAssignableFrom(shape.getClass())) {
            Set types = ((ShapeCollection)shape).getShapes().stream().map(this::getType).collect(Collectors.toSet());
            switch (types.size() == 1 ? (Geoshape.Type)((Object)types.iterator().next()) : Geoshape.Type.GEOMETRYCOLLECTION) {
                case POINT: {
                    type = Geoshape.Type.MULTIPOINT;
                    break;
                }
                case LINE: {
                    type = Geoshape.Type.MULTILINESTRING;
                    break;
                }
                case POLYGON: {
                    type = Geoshape.Type.MULTIPOLYGON;
                    break;
                }
                default: {
                    type = Geoshape.Type.GEOMETRYCOLLECTION;
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Unrecognized shape type: " + shape.getClass());
        }
        return type;
    }

    public int size(Shape shape) {
        switch (this.getType(shape)) {
            case POINT: {
                return 1;
            }
            case CIRCLE: {
                return 1;
            }
            case BOX: {
                return 2;
            }
            case LINE: {
                return ((BufferedLineString)shape).getPoints().size();
            }
            case MULTIPOINT: {
                return ((ShapeCollection)shape).getShapes().size();
            }
            case MULTILINESTRING: {
                return ((ShapeCollection)shape).getShapes().stream().map(s -> (BufferedLineString)s).mapToInt(s -> s.getPoints().size()).sum();
            }
            case GEOMETRYCOLLECTION: {
                return ((ShapeCollection)shape).getShapes().stream().map(s -> s).mapToInt(s -> this.size((Shape)s)).sum();
            }
        }
        throw new IllegalStateException("size() not supported for type: " + (Object)((Object)this.getType(shape)));
    }

    public Geoshape.Point getPoint(Geoshape geoshape, int position) {
        Point p;
        Shape shape = geoshape.getShape();
        if (position < 0 || position >= this.size(shape)) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        switch (this.getType(shape)) {
            case POINT: 
            case CIRCLE: {
                return geoshape.getPoint();
            }
            case BOX: {
                if (position == 0) {
                    return new Geoshape.Point(shape.getBoundingBox().getMinY(), shape.getBoundingBox().getMinX());
                }
                return new Geoshape.Point(shape.getBoundingBox().getMaxY(), shape.getBoundingBox().getMaxX());
            }
            case LINE: {
                p = (Point)((BufferedLineString)shape).getPoints().get(position);
                break;
            }
            case MULTIPOINT: {
                p = (Point)((ShapeCollection)shape).getShapes().get(position);
                break;
            }
            case MULTILINESTRING: {
                p = ((ShapeCollection)shape).getShapes().stream().flatMap(line -> line.getPoints().stream()).skip(position).findFirst().orElse(null);
                break;
            }
            case GEOMETRYCOLLECTION: {
                return ((ShapeCollection)shape).getShapes().stream().flatMap(internShape -> IntStream.range(0, this.size((Shape)internShape)).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Shape, Integer>((Shape)internShape, i))).skip(position).findFirst().map(entry -> this.getPoint(new Geoshape((Shape)entry.getKey()), (Integer)entry.getValue())).orElse(null);
            }
            default: {
                throw new IllegalStateException("getPoint(int) not supported for type: " + (Object)((Object)this.getType(shape)));
            }
        }
        if (p == null) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        return new Geoshape.Point(p.getY(), p.getX());
    }

    public boolean isJts(Shape shape) {
        return false;
    }

    public SpatialContext getContext() {
        return this.context;
    }

    public WKTReader getWktReader() {
        return this.wktReader;
    }

    public WKTWriter getWktWriter() {
        return this.wktWriter;
    }

    public GeoJSONReader getGeojsonReader() {
        return this.geojsonReader;
    }

    public GeoJSONWriter getGeojsonWriter() {
        return this.geojsonWriter;
    }

    public BinaryCodec getBinaryCodec() {
        return this.binaryCodec;
    }
}

