/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.GeoshapeHelper;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.io.GeoJSONReader;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.io.jts.JtsBinaryCodec;
import org.locationtech.spatial4j.io.jts.JtsGeoJSONWriter;
import org.locationtech.spatial4j.io.jts.JtsWKTWriter;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class JtsGeoshapeHelper
extends GeoshapeHelper {
    public JtsGeoshapeHelper() {
        JtsSpatialContextFactory jtsFactory = new JtsSpatialContextFactory();
        jtsFactory.geo = true;
        jtsFactory.useJtsPoint = false;
        jtsFactory.useJtsLineString = true;
        jtsFactory.datelineRule = DatelineRule.none;
        JtsSpatialContext context = new JtsSpatialContext(jtsFactory);
        this.context = context;
        this.factory = jtsFactory;
        this.wktReader = new WKTReader((SpatialContext)context, this.factory);
        this.wktWriter = new JtsWKTWriter(context, jtsFactory);
        this.geojsonReader = new GeoJSONReader((SpatialContext)context, this.factory);
        this.geojsonWriter = new JtsGeoJSONWriter(context, (SpatialContextFactory)jtsFactory);
        this.binaryCodec = new JtsBinaryCodec(context, jtsFactory);
    }

    public Geoshape geoshape(Geometry geometry) {
        return new Geoshape(((JtsSpatialContext)this.context).getShapeFactory().makeShapeFromGeometry(geometry));
    }

    @Override
    public Shape readGeometry(DataInputStream dataInput) throws IOException {
        return ((JtsBinaryCodec)this.binaryCodec).readJtsGeom((DataInput)dataInput);
    }

    @Override
    public void write(DataOutputStream dataOutput, Geoshape attribute) throws IOException {
        if (attribute.getShape() instanceof JtsGeometry) {
            ((JtsBinaryCodec)this.binaryCodec).writeJtsGeom((DataOutput)dataOutput, attribute.getShape());
        } else {
            this.binaryCodec.writeShape((DataOutput)dataOutput, attribute.getShape());
        }
    }

    @Override
    public Geoshape polygon(List<double[]> coordinates) {
        Preconditions.checkArgument((coordinates.size() >= 4 ? 1 : 0) != 0, (Object)"Too few coordinate pairs provided");
        Preconditions.checkArgument((coordinates.get(0) != coordinates.get(coordinates.size() - 1) ? 1 : 0) != 0, (Object)"Polygon is not closed");
        ShapeFactory.PolygonBuilder builder = this.getContext().getShapeFactory().polygon();
        for (double[] coordinate : coordinates) {
            Preconditions.checkArgument((coordinate.length == 2 && Geoshape.isValidCoordinate(coordinate[1], coordinate[0]) ? 1 : 0) != 0, (Object)"Invalid coordinate provided");
            builder.pointXY(coordinate[0], coordinate[1]);
        }
        return new Geoshape(builder.build());
    }

    @Override
    public Geoshape.Type getType(Shape shape) {
        Geoshape.Type type;
        if (JtsGeometry.class.isAssignableFrom(shape.getClass()) && "LineString".equals(((JtsGeometry)shape).getGeom().getGeometryType())) {
            type = Geoshape.Type.LINE;
        } else if (JtsGeometry.class.isAssignableFrom(shape.getClass())) {
            try {
                type = Geoshape.Type.fromGson(((JtsGeometry)shape).getGeom().getGeometryType());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unrecognized shape type");
            }
        } else {
            type = super.getType(shape);
        }
        return type;
    }

    @Override
    public int size(Shape shape) {
        switch (this.getType(shape)) {
            case LINE: 
            case POLYGON: 
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                return ((JtsGeometry)shape).getGeom().getCoordinates().length;
            }
        }
        return super.size(shape);
    }

    @Override
    public Geoshape.Point getPoint(Geoshape geoshape, int position) {
        Shape shape = geoshape.getShape();
        if (position < 0 || position >= this.size(shape)) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        switch (this.getType(shape)) {
            case LINE: 
            case POLYGON: 
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                Coordinate coordinate = ((JtsGeometry)shape).getGeom().getCoordinates()[position];
                return new Geoshape.Point(coordinate.y, coordinate.x);
            }
        }
        return super.getPoint(geoshape, position);
    }

    @Override
    public boolean isJts(Shape shape) {
        return shape instanceof JtsGeometry;
    }
}

