/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;

public class KeyRangeQuery
extends SliceQuery {
    private final StaticBuffer keyStart;
    private final StaticBuffer keyEnd;

    public KeyRangeQuery(StaticBuffer keyStart, StaticBuffer keyEnd, StaticBuffer sliceStart, StaticBuffer sliceEnd) {
        super(sliceStart, sliceEnd);
        Preconditions.checkNotNull((Object)keyStart);
        Preconditions.checkNotNull((Object)keyEnd);
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    public KeyRangeQuery(StaticBuffer keyStart, StaticBuffer keyEnd, SliceQuery query) {
        super(query);
        Preconditions.checkNotNull((Object)keyStart);
        Preconditions.checkNotNull((Object)keyEnd);
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    public StaticBuffer getKeyStart() {
        return this.keyStart;
    }

    public StaticBuffer getKeyEnd() {
        return this.keyEnd;
    }

    @Override
    public KeyRangeQuery setLimit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public KeyRangeQuery updateLimit(int newLimit) {
        return new KeyRangeQuery(this.keyStart, this.keyEnd, this).setLimit(newLimit);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.keyStart).append((Object)this.keyEnd).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        KeyRangeQuery oth = (KeyRangeQuery)other;
        return this.keyStart.equals(oth.keyStart) && this.keyEnd.equals(oth.keyEnd) && super.equals(oth);
    }

    public boolean subsumes(KeyRangeQuery oth) {
        return super.subsumes(oth) && this.keyStart.compareTo(oth.keyStart) <= 0 && this.keyEnd.compareTo(oth.keyEnd) >= 0;
    }

    public String toString() {
        return String.format("KeyRangeQuery(start: %s, end: %s, columns:[start: %s, end: %s], limit=%d)", this.keyStart, this.keyEnd, this.getSliceStart(), this.getSliceEnd(), this.getLimit());
    }
}

