/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking.consistentkey;

import java.util.List;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSProxy;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingStore
extends KCVSProxy {
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingStore.class);
    final Locker locker;

    public ExpectedValueCheckingStore(KeyColumnValueStore store, Locker locker) {
        super(store);
        this.locker = locker;
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        ExpectedValueCheckingTransaction etx = (ExpectedValueCheckingTransaction)txh;
        boolean hasAtLeastOneLock = etx.prepareForMutations();
        if (hasAtLeastOneLock) {
            this.store.mutate(key, additions, deletions, ExpectedValueCheckingStore.getConsistentTx(txh));
        } else {
            this.store.mutate(key, additions, deletions, this.unwrapTx(txh));
        }
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        if (this.locker != null) {
            ExpectedValueCheckingTransaction tx = (ExpectedValueCheckingTransaction)txh;
            if (tx.isMutationStarted()) {
                throw new PermanentLockingException("Attempted to obtain a lock after mutations had been persisted");
            }
            KeyColumn lockID = new KeyColumn(key, column);
            log.debug("Attempting to acquireLock on {} ev={}", (Object)lockID, (Object)expectedValue);
            this.locker.writeLock(lockID, tx.getConsistentTx());
            tx.storeExpectedValue(this, lockID, expectedValue);
        } else {
            this.store.acquireLock(key, column, expectedValue, this.unwrapTx(txh));
        }
    }

    Locker getLocker() {
        return this.locker;
    }

    void deleteLocks(ExpectedValueCheckingTransaction tx) throws BackendException {
        this.locker.deleteLocks(tx.getConsistentTx());
    }

    KeyColumnValueStore getBackingStore() {
        return this.store;
    }

    @Override
    protected StoreTransaction unwrapTx(StoreTransaction t) {
        assert (null != t);
        assert (t instanceof ExpectedValueCheckingTransaction);
        return ((ExpectedValueCheckingTransaction)t).getInconsistentTx();
    }

    private static StoreTransaction getConsistentTx(StoreTransaction t) {
        assert (null != t);
        assert (t instanceof ExpectedValueCheckingTransaction);
        return ((ExpectedValueCheckingTransaction)t).getConsistentTx();
    }
}

