/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.idassigner.placement;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.graphdb.database.idassigner.IDPoolExhaustedException;
import org.janusgraph.graphdb.database.idassigner.placement.PartitionAssignment;
import org.janusgraph.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import org.janusgraph.graphdb.database.idassigner.placement.SimplePartitionAssignment;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalVertex;

@PreInitializeConfigOptions
public class PropertyPlacementStrategy
extends SimpleBulkPlacementStrategy {
    public static final ConfigOption<String> PARTITION_KEY = new ConfigOption<Predicate>(GraphDatabaseConfiguration.IDS_NS, "partition-key", "Partitions the graph by properties of this key", ConfigOption.Type.MASKABLE, (Class<Predicate>)String.class, key -> StringUtils.isNotBlank((CharSequence)key));
    private String key;
    private IDManager idManager;

    public PropertyPlacementStrategy(Configuration config) {
        super(config);
        this.setPartitionKey(config.get(PARTITION_KEY, new String[0]));
    }

    public PropertyPlacementStrategy(String key, int concurrentPartitions) {
        super(concurrentPartitions);
        this.setPartitionKey(key);
    }

    public void setPartitionKey(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"Invalid key configured: %s", (Object[])new Object[]{key});
        this.key = key;
    }

    @Override
    public void injectIDManager(IDManager idManager) {
        Preconditions.checkNotNull((Object)idManager);
        this.idManager = idManager;
    }

    @Override
    public int getPartition(InternalElement element) {
        int pid;
        if (element instanceof JanusGraphVertex && (pid = this.getPartitionIDbyKey((JanusGraphVertex)((Object)element))) >= 0) {
            return pid;
        }
        return super.getPartition(element);
    }

    @Override
    public void getPartitions(Map<InternalVertex, PartitionAssignment> vertices) {
        super.getPartitions(vertices);
        for (Map.Entry<InternalVertex, PartitionAssignment> entry : vertices.entrySet()) {
            int pid = this.getPartitionIDbyKey(entry.getKey());
            if (pid < 0) continue;
            ((SimplePartitionAssignment)entry.getValue()).setPartitionID(pid);
        }
    }

    private int getPartitionIDbyKey(JanusGraphVertex vertex) {
        Preconditions.checkState((this.idManager != null && this.key != null ? 1 : 0) != 0, (Object)"PropertyPlacementStrategy has not been initialized correctly");
        assert (this.idManager.getPartitionBound() <= Integer.MAX_VALUE);
        int partitionBound = (int)this.idManager.getPartitionBound();
        JanusGraphVertexProperty p = (JanusGraphVertexProperty)Iterables.getFirst(vertex.query().keys(new String[]{this.key}).properties(), null);
        if (p == null) {
            return -1;
        }
        int hashPid = Math.abs(p.value().hashCode()) % partitionBound;
        assert (hashPid >= 0 && hashPid < partitionBound);
        if (this.isExhaustedPartition(hashPid)) {
            int newPid = hashPid;
            do {
                if ((newPid = (newPid + 1) % partitionBound) != hashPid) continue;
                throw new IDPoolExhaustedException("Could not find non-exhausted partition");
            } while (this.isExhaustedPartition(newPid));
            return newPid;
        }
        return hashPid;
    }
}

