/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.idhandling;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.util.WriteByteBuffer;

public class VariableLong {
    private static final byte BIT_MASK = 127;
    private static final byte STOP_MASK = -128;

    public static int unsignedByte(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static byte unsignedByte(int value) {
        Preconditions.checkArgument((value >= 0 && value < 256 ? 1 : 0) != 0, (String)"Value overflow: %s", (Object[])new Object[]{value});
        return (byte)(value & 0xFF);
    }

    private static long readUnsigned(ScanBuffer in) {
        byte b;
        long value = 0L;
        do {
            b = in.getByte();
            value = value << 7 | (long)(b & 0x7F);
        } while (b >= 0);
        return value;
    }

    private static void writeUnsigned(WriteBuffer out, long value) {
        VariableLong.writeUnsigned(out, VariableLong.unsignedBlockBitLength(value), value);
    }

    private static void writeUnsigned(WriteBuffer out, int offset, long value) {
        assert (offset % 7 == 0);
        while (offset > 0) {
            byte b = (byte)(value >>> (offset -= 7) & 0x7FL);
            if (offset == 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.putByte(b);
        }
    }

    private static int unsignedBlockBitLength(long value) {
        return VariableLong.unsignedNumBlocks(value) * 7;
    }

    private static int unsignedNumBlocks(long value) {
        return VariableLong.numVariableBlocks(VariableLong.unsignedBitLength(value));
    }

    private static int numVariableBlocks(int numBits) {
        assert (numBits > 0);
        return (numBits - 1) / 7 + 1;
    }

    public static int unsignedBitLength(long value) {
        return value == 0L ? 1 : 64 - Long.numberOfLeadingZeros(value);
    }

    public static long readPositive(ScanBuffer in) {
        long value = VariableLong.readUnsigned(in);
        assert (value >= 0L);
        return value;
    }

    public static void writePositive(WriteBuffer out, long value) {
        assert (value >= 0L);
        VariableLong.writeUnsigned(out, value);
    }

    public static StaticBuffer positiveBuffer(long value) {
        WriteByteBuffer buffer = new WriteByteBuffer(VariableLong.positiveLength(value));
        VariableLong.writePositive(buffer, value);
        return buffer.getStaticBuffer();
    }

    public static StaticBuffer positiveBuffer(long[] value) {
        int len = 0;
        for (long aValue : value) {
            len += VariableLong.positiveLength(aValue);
        }
        WriteByteBuffer buffer = new WriteByteBuffer(len);
        for (long aValue : value) {
            VariableLong.writePositive(buffer, aValue);
        }
        return buffer.getStaticBuffer();
    }

    public static int positiveLength(long value) {
        assert (value >= 0L);
        return VariableLong.unsignedNumBlocks(value);
    }

    private static long convert2Unsigned(long value) {
        assert (value >= 0L || value > Long.MIN_VALUE);
        return Math.abs(value) << 1 | (long)(value < 0L ? 1 : 0);
    }

    private static long convertFromUnsigned(long value) {
        return (value & 1L) == 1L ? -(value >>> 1) : value >>> 1;
    }

    public static int length(long value) {
        return VariableLong.unsignedNumBlocks(VariableLong.convert2Unsigned(value));
    }

    public static void write(WriteBuffer out, long value) {
        VariableLong.writeUnsigned(out, VariableLong.convert2Unsigned(value));
    }

    public static long read(ScanBuffer in) {
        return VariableLong.convertFromUnsigned(VariableLong.readUnsigned(in));
    }

    public static void writePositiveWithPrefix(WriteBuffer out, long value, long prefix, int prefixBitLen) {
        assert (value >= 0L);
        assert (prefixBitLen > 0 && prefixBitLen < 6 && prefix < 1L << prefixBitLen);
        int deltaLen = 8 - prefixBitLen;
        byte first = (byte)(prefix << deltaLen);
        int valueLen = VariableLong.unsignedBitLength(value);
        int mod = valueLen % 7;
        if (mod <= deltaLen - 1) {
            int offset = valueLen - mod;
            first = (byte)((long)first | value >>> offset);
            value &= (1L << offset) - 1L;
            valueLen -= mod;
        } else {
            valueLen += 7 - mod;
        }
        assert (valueLen >= 0);
        if (valueLen > 0) {
            first = (byte)(first | 1 << deltaLen - 1);
        }
        out.putByte(first);
        if (valueLen > 0) {
            VariableLong.writeUnsigned(out, valueLen, value);
        }
    }

    public static int positiveWithPrefixLength(long value, int prefixBitLen) {
        assert (value >= 0L);
        assert (prefixBitLen > 0 && prefixBitLen < 6);
        return VariableLong.numVariableBlocks(VariableLong.unsignedBitLength(value) + prefixBitLen);
    }

    public static long[] readPositiveWithPrefix(ReadBuffer in, int prefixBitLen) {
        assert (prefixBitLen > 0 && prefixBitLen < 6);
        int first = VariableLong.unsignedByte(in.getByte());
        int deltaLen = 8 - prefixBitLen;
        long prefix = first >> deltaLen;
        long value = first & (1 << deltaLen - 1) - 1;
        if ((first >>> deltaLen - 1 & 1) == 1) {
            int deltaPos = in.getPosition();
            long remainder = VariableLong.readUnsigned(in);
            deltaPos = in.getPosition() - deltaPos;
            assert (deltaPos > 0);
            value = (value << deltaPos * 7) + remainder;
        }
        return new long[]{value, prefix};
    }

    public static void writePositiveBackward(WriteBuffer out, long value) {
        assert (value >= 0L);
        VariableLong.writeUnsignedBackward(out, value);
    }

    public static int positiveBackwardLength(long value) {
        assert (value >= 0L);
        return VariableLong.unsignedBackwardLength(value);
    }

    public static long readPositiveBackward(ReadBuffer in) {
        return VariableLong.readUnsignedBackward(in);
    }

    public static void writeBackward(WriteBuffer out, long value) {
        VariableLong.writeUnsignedBackward(out, VariableLong.convert2Unsigned(value));
    }

    public static int backwardLength(long value) {
        return VariableLong.unsignedBackwardLength(VariableLong.convert2Unsigned(value));
    }

    public static long readBackward(ReadBuffer in) {
        return VariableLong.convertFromUnsigned(VariableLong.readUnsignedBackward(in));
    }

    private static void writeUnsignedBackward(WriteBuffer out, long value) {
        int numBytes = VariableLong.unsignedBackwardLength(value);
        int prefixLen = numBytes - 3;
        assert (prefixLen >= 0 && prefixLen < 8);
        byte b = (byte)(prefixLen << 4 | 0x80);
        for (int i = numBytes - 1; i >= 0; --i) {
            b = (byte)((long)b | 0x7FL & value >>> i * 7);
            out.putByte(b);
            b = 0;
        }
    }

    private static int unsignedBackwardLength(long value) {
        int bitlength = VariableLong.unsignedBitLength(value);
        assert (bitlength > 0 && bitlength <= 64);
        int numBytes = Math.max(3, 1 + (bitlength <= 4 ? 0 : 1 + (bitlength - 5) / 7));
        return numBytes;
    }

    private static long readUnsignedBackward(ReadBuffer in) {
        int position = in.getPosition();
        int numBytes = 0;
        long value = 0L;
        while (true) {
            long b;
            if ((b = (long)in.getByte(--position)) < 0L) {
                value |= (b & 0xFL) << 7 * numBytes;
                assert ((b >>> 4 & 7L) + 3L == (long)(numBytes + 1)) : b + " vs " + numBytes;
                break;
            }
            value |= b << 7 * numBytes;
            ++numBytes;
        }
        in.movePositionTo(position);
        return value;
    }
}

