/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.util.time.Timer;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.database.management.AbstractIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.GraphIndexStatusReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIndexStatusWatcher
extends AbstractIndexStatusWatcher<GraphIndexStatusReport, GraphIndexStatusWatcher> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphIndexStatusWatcher.class);
    private String graphIndexName;

    public GraphIndexStatusWatcher(JanusGraph g, String graphIndexName) {
        super(g);
        this.graphIndexName = graphIndexName;
    }

    @Override
    protected GraphIndexStatusWatcher self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphIndexStatusReport call() throws InterruptedException {
        Preconditions.checkNotNull((Object)this.g, (Object)"Graph instance must not be null");
        Preconditions.checkNotNull((Object)this.graphIndexName, (Object)"Index name must not be null");
        Preconditions.checkNotNull((Object)this.statuses, (Object)"Target statuses must not be null");
        Preconditions.checkArgument((this.statuses.size() > 0 ? 1 : 0) != 0, (Object)"Target statuses must include at least one status");
        HashMap<String, SchemaStatus> notConverged = new HashMap<String, SchemaStatus>();
        HashMap<String, SchemaStatus> converged = new HashMap<String, SchemaStatus>();
        Timer t = new Timer(TimestampProviders.MILLI).start();
        while (true) {
            boolean timedOut;
            JanusGraphManagement mgmt = null;
            try {
                mgmt = this.g.openManagement();
                JanusGraphIndex idx = mgmt.getGraphIndex(this.graphIndexName);
                for (PropertyKey pk : idx.getFieldKeys()) {
                    SchemaStatus s = idx.getIndexStatus(pk);
                    LOGGER.debug("Key {} has status {}", (Object)pk, (Object)s);
                    if (!this.statuses.contains((Object)s)) {
                        notConverged.put(pk.toString(), s);
                        continue;
                    }
                    converged.put(pk.toString(), s);
                }
            }
            finally {
                if (null != mgmt) {
                    mgmt.rollback();
                }
            }
            String waitingOn = Joiner.on((String)",").withKeyValueSeparator("=").join(notConverged);
            if (notConverged.isEmpty()) {
                LOGGER.info("All {} key(s) on index {} have status(es) {}", new Object[]{converged.size(), this.graphIndexName, this.statuses});
                return new GraphIndexStatusReport(true, this.graphIndexName, this.statuses, notConverged, converged, t.elapsed());
            }
            LOGGER.info("Some key(s) on index {} do not currently have status(es) {}: {}", new Object[]{this.graphIndexName, this.statuses, waitingOn});
            boolean bl = timedOut = null != this.timeout && 0 < t.elapsed().compareTo(this.timeout);
            if (timedOut) {
                LOGGER.info("Timed out ({}) while waiting for index {} to converge on status(es) {}", new Object[]{this.timeout, this.graphIndexName, this.statuses});
                return new GraphIndexStatusReport(false, this.graphIndexName, this.statuses, notConverged, converged, t.elapsed());
            }
            notConverged.clear();
            converged.clear();
            Thread.sleep(this.poll.toMillis());
        }
    }
}

