/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.idmanagement.ConflictAvoidanceMode;
import org.janusgraph.diskstorage.util.WriteByteBuffer;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.log.LogTxStatus;
import org.janusgraph.graphdb.database.management.MgmtLogType;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.database.serialize.SerializerInjected;
import org.janusgraph.graphdb.database.serialize.SupportsNullSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.BooleanArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.BooleanSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ByteArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ByteSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.CharArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.CharacterSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.DateSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.DoubleArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.DoubleSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.DurationSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.EnumSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.FloatArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.FloatSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.InstantSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.IntArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.IntegerSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ObjectSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ParameterArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ParameterSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.SerializableSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ShortArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ShortSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.StandardTransactionIdSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.StringArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.StringSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.TypeDefinitionDescriptionSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.UUIDSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.log.StandardTransactionId;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;

public class StandardSerializer
implements AttributeHandler,
Serializer {
    private static final int CLASS_REGISTRATION_OFFSET = 100;
    private static final int MAX_REGISTRATION_NO = 100000;
    private final BiMap<Integer, Class> registrations;
    private final Map<Class, AttributeSerializer> handlers = new HashMap<Class, AttributeSerializer>(60);

    public StandardSerializer() {
        this.registrations = HashBiMap.create((int)60);
        this.registerClassInternal(1, Object.class, new ObjectSerializer());
        this.registerClassInternal(10, Byte.class, new ByteSerializer());
        this.registerClassInternal(11, Short.class, new ShortSerializer());
        this.registerClassInternal(12, Integer.class, new IntegerSerializer());
        this.registerClassInternal(13, Long.class, new LongSerializer());
        this.registerClassInternal(14, Character.class, new CharacterSerializer());
        this.registerClassInternal(15, Boolean.class, new BooleanSerializer());
        this.registerClassInternal(16, Date.class, new DateSerializer());
        this.registerClassInternal(17, Geoshape.class, new Geoshape.GeoshapeSerializer());
        this.registerClassInternal(18, String.class, new StringSerializer());
        this.registerClassInternal(19, Float.class, new FloatSerializer());
        this.registerClassInternal(20, Double.class, new DoubleSerializer());
        this.registerClassInternal(21, UUID.class, new UUIDSerializer());
        this.registerClassInternal(22, byte[].class, new ByteArraySerializer());
        this.registerClassInternal(23, short[].class, new ShortArraySerializer());
        this.registerClassInternal(24, int[].class, new IntArraySerializer());
        this.registerClassInternal(25, long[].class, new LongArraySerializer());
        this.registerClassInternal(26, float[].class, new FloatArraySerializer());
        this.registerClassInternal(27, double[].class, new DoubleArraySerializer());
        this.registerClassInternal(28, char[].class, new CharArraySerializer());
        this.registerClassInternal(29, boolean[].class, new BooleanArraySerializer());
        this.registerClassInternal(30, String[].class, new StringArraySerializer());
        this.registerClassInternal(41, TypeDefinitionCategory.class, new EnumSerializer<TypeDefinitionCategory>(TypeDefinitionCategory.class));
        this.registerClassInternal(42, JanusGraphSchemaCategory.class, new EnumSerializer<JanusGraphSchemaCategory>(JanusGraphSchemaCategory.class));
        this.registerClassInternal(43, ParameterType.class, new EnumSerializer<ParameterType>(ParameterType.class));
        this.registerClassInternal(44, RelationCategory.class, new EnumSerializer<RelationCategory>(RelationCategory.class));
        this.registerClassInternal(45, Order.class, new EnumSerializer<Order>(Order.class));
        this.registerClassInternal(46, Multiplicity.class, new EnumSerializer<Multiplicity>(Multiplicity.class));
        this.registerClassInternal(47, Cardinality.class, new EnumSerializer<Cardinality>(Cardinality.class));
        this.registerClassInternal(48, Direction.class, new EnumSerializer<Direction>(Direction.class));
        this.registerClassInternal(49, ElementCategory.class, new EnumSerializer<ElementCategory>(ElementCategory.class));
        this.registerClassInternal(50, ConsistencyModifier.class, new EnumSerializer<ConsistencyModifier>(ConsistencyModifier.class));
        this.registerClassInternal(51, SchemaStatus.class, new EnumSerializer<SchemaStatus>(SchemaStatus.class));
        this.registerClassInternal(52, LogTxStatus.class, new EnumSerializer<LogTxStatus>(LogTxStatus.class));
        this.registerClassInternal(53, MgmtLogType.class, new EnumSerializer<MgmtLogType>(MgmtLogType.class));
        this.registerClassInternal(54, TimestampProviders.class, new EnumSerializer<TimestampProviders>(TimestampProviders.class));
        this.registerClassInternal(55, TimeUnit.class, new EnumSerializer<TimeUnit>(TimeUnit.class));
        this.registerClassInternal(56, Mapping.class, new EnumSerializer<Mapping>(Mapping.class));
        this.registerClassInternal(57, ConflictAvoidanceMode.class, new EnumSerializer<ConflictAvoidanceMode>(ConflictAvoidanceMode.class));
        this.registerClassInternal(60, Class.class, new ClassSerializer());
        this.registerClassInternal(61, Parameter.class, new ParameterSerializer());
        this.registerClassInternal(62, Parameter[].class, new ParameterArraySerializer());
        this.registerClassInternal(63, TypeDefinitionDescription.class, new TypeDefinitionDescriptionSerializer());
        this.registerClassInternal(64, Duration.class, new DurationSerializer());
        this.registerClassInternal(65, Instant.class, new InstantSerializer());
        this.registerClassInternal(66, StandardTransactionId.class, new StandardTransactionIdSerializer());
        this.registerClassInternal(67, TraverserSet.class, new SerializableSerializer());
        this.registerClassInternal(68, HashMap.class, new SerializableSerializer());
    }

    public synchronized <V> void registerClass(int registrationNo, Class<V> datatype, AttributeSerializer<V> serializer) {
        Integer hashMapRegNo;
        Preconditions.checkArgument((registrationNo >= 0 && registrationNo < 100000 ? 1 : 0) != 0, (String)"Registration number out of range [0,%s]: %s", (Object[])new Object[]{100000, registrationNo});
        if (datatype == HashMap.class && (hashMapRegNo = (Integer)this.registrations.inverse().get((Object)StandardSerializer.normalizeDataType(HashMap.class))) != null) {
            this.registrations.remove((Object)hashMapRegNo);
            this.handlers.remove(datatype);
        }
        this.registerClassInternal(100 + registrationNo, datatype, serializer);
    }

    public synchronized <V> void registerClassInternal(int registrationNo, Class<? extends V> datatype, AttributeSerializer<V> serializer) {
        Preconditions.checkArgument((registrationNo > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(datatype);
        Preconditions.checkArgument((!this.handlers.containsKey(datatype) ? 1 : 0) != 0, (String)"DataType has already been registered: %s", (Object[])new Object[]{datatype});
        Preconditions.checkArgument((!this.registrations.containsKey((Object)registrationNo) ? 1 : 0) != 0, (String)"A datatype has already been registered for no: %s", (Object[])new Object[]{registrationNo});
        Preconditions.checkNotNull(serializer, (String)"Need to provide a serializer for datatype: %s", (Object[])new Object[]{datatype});
        this.registrations.put((Object)registrationNo, datatype);
        if (serializer instanceof SerializerInjected) {
            ((SerializerInjected)((Object)serializer)).setSerializer(this);
        }
        this.handlers.put(datatype, serializer);
    }

    private static Class normalizeDataType(Class datatype) {
        Class superClass = datatype.getSuperclass();
        if (null != superClass && superClass.isEnum()) {
            return superClass;
        }
        if (Instant.class.equals((Object)datatype)) {
            return Instant.class;
        }
        return datatype;
    }

    @Override
    public boolean validDataType(Class datatype) {
        return this.handlers.containsKey(StandardSerializer.normalizeDataType(datatype));
    }

    private <T> AttributeSerializer<T> getSerializer(Class<T> datatype) {
        AttributeSerializer serializer = this.handlers.get(StandardSerializer.normalizeDataType(datatype));
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (String)"Datatype is not supported by database since no serializer has been registered: %s", (Object[])new Object[]{datatype});
        return serializer;
    }

    private int getDataTypeRegistration(Class datatype) {
        Integer registrationNo = (Integer)this.registrations.inverse().get((Object)StandardSerializer.normalizeDataType(datatype));
        Preconditions.checkArgument((registrationNo != null ? 1 : 0) != 0, (String)"Datatype is not supported by database since no serializer has been registered: %s", (Object[])new Object[]{datatype});
        assert (registrationNo > 0);
        return registrationNo;
    }

    private Class getDataType(int registrationNo) {
        Class clazz = (Class)this.registrations.get((Object)registrationNo);
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (String)"Encountered missing datatype registration for number: %s", (Object[])new Object[]{registrationNo});
        return clazz;
    }

    @Override
    public <V> void verifyAttribute(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeSerializer<Object> handler = this.getSerializer(datatype);
        if (handler != null) {
            handler.verifyAttribute(value);
        }
    }

    @Override
    public <V> V convert(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeSerializer<V> handler = this.getSerializer(datatype);
        if (handler != null) {
            return handler.convert(value);
        }
        return null;
    }

    @Override
    public boolean isOrderPreservingDatatype(Class<?> datatype) {
        return this.getSerializer(datatype) instanceof OrderPreservingSerializer;
    }

    private static <V> OrderPreservingSerializer<V> ensureOrderPreserving(AttributeSerializer<V> serializer, Class<V> type) {
        Preconditions.checkArgument((boolean)(serializer instanceof OrderPreservingSerializer), (String)"Registered serializer for datatype does not support order: %s", (Object[])new Object[]{type});
        return (OrderPreservingSerializer)serializer;
    }

    private boolean supportsNullSerialization(Class type) {
        return this.getSerializer(type) instanceof SupportsNullSerializer;
    }

    @Override
    public <T> T readObjectByteOrder(ScanBuffer buffer, Class<T> type) {
        return this.readObjectInternal(buffer, type, true);
    }

    @Override
    public <T> T readObject(ScanBuffer buffer, Class<T> type) {
        return this.readObjectInternal(buffer, type, false);
    }

    @Override
    public <T> T readObjectNotNull(ScanBuffer buffer, Class<T> type) {
        return this.readObjectNotNullInternal(buffer, type, false);
    }

    private <T> T readObjectInternal(ScanBuffer buffer, Class<T> type, boolean byteOrder) {
        if (this.supportsNullSerialization(type)) {
            AttributeSerializer<T> s = this.getSerializer(type);
            if (byteOrder) {
                return StandardSerializer.ensureOrderPreserving(s, type).readByteOrder(buffer);
            }
            return s.read(buffer);
        }
        byte flag = buffer.getByte();
        if (flag == -1) {
            return null;
        }
        Preconditions.checkArgument((flag == 0 ? 1 : 0) != 0, (String)"Invalid flag encountered in serialization: %s. Corrupted data.", (Object[])new Object[]{flag});
        return this.readObjectNotNullInternal(buffer, type, byteOrder);
    }

    private <T> T readObjectNotNullInternal(ScanBuffer buffer, Class<T> type, boolean byteOrder) {
        AttributeSerializer<T> s = this.getSerializer(type);
        if (byteOrder) {
            return StandardSerializer.ensureOrderPreserving(s, type).readByteOrder(buffer);
        }
        return s.read(buffer);
    }

    @Override
    public Object readClassAndObject(ScanBuffer buffer) {
        long registrationNo = VariableLong.readPositive(buffer);
        if (registrationNo == 0L) {
            return null;
        }
        Class datatype = this.getDataType((int)registrationNo);
        return this.readObjectNotNullInternal(buffer, datatype, false);
    }

    @Override
    public DataOutput getDataOutput(int initialCapacity) {
        return new StandardDataOutput(initialCapacity);
    }

    @Override
    public void close() throws IOException {
    }

    private class ClassSerializer
    implements OrderPreservingSerializer<Class>,
    SupportsNullSerializer {
        private final IntegerSerializer ints = new IntegerSerializer();

        private ClassSerializer() {
        }

        @Override
        public Class readByteOrder(ScanBuffer buffer) {
            return this.getClass(this.ints.readByteOrder(buffer).intValue());
        }

        @Override
        public void writeByteOrder(WriteBuffer buffer, Class attribute) {
            this.ints.writeByteOrder(buffer, attribute == null ? 0 : StandardSerializer.this.getDataTypeRegistration(attribute));
        }

        @Override
        public Class read(ScanBuffer buffer) {
            return this.getClass(VariableLong.readPositive(buffer));
        }

        private final Class getClass(long registrationNo) {
            assert (registrationNo < Integer.MAX_VALUE && registrationNo >= 0L);
            if (registrationNo == 0L) {
                return null;
            }
            return StandardSerializer.this.getDataType((int)registrationNo);
        }

        @Override
        public void write(WriteBuffer buffer, Class attribute) {
            VariableLong.writePositive(buffer, attribute == null ? 0L : (long)StandardSerializer.this.getDataTypeRegistration(attribute));
        }

        @Override
        public void verifyAttribute(Class value) {
        }

        @Override
        public Class convert(Object value) {
            if (value instanceof Class) {
                return (Class)value;
            }
            return null;
        }
    }

    private class StandardDataOutput
    extends WriteByteBuffer
    implements DataOutput {
        private StandardDataOutput(int initialCapacity) {
            super(initialCapacity);
        }

        public DataOutput writeObjectByteOrder(Object object, Class type) {
            Preconditions.checkArgument((boolean)StandardSerializer.this.isOrderPreservingDatatype(type), (String)"Invalid serializer for class: %s", (Object[])new Object[]{type});
            return this.writeObjectInternal(object, type, true);
        }

        public DataOutput writeObject(Object object, Class type) {
            return this.writeObjectInternal(object, type, false);
        }

        @Override
        public DataOutput writeObjectNotNull(Object object) {
            return this.writeObjectNotNullInternal(object, false);
        }

        private DataOutput writeObjectInternal(Object object, Class type, boolean byteOrder) {
            if (StandardSerializer.this.supportsNullSerialization(type)) {
                AttributeSerializer s = StandardSerializer.this.getSerializer(type);
                if (byteOrder) {
                    StandardSerializer.ensureOrderPreserving(s, type).writeByteOrder(this, object);
                } else {
                    s.write(this, object);
                }
            } else if (object == null) {
                this.putByte((byte)-1);
            } else {
                this.putByte((byte)0);
                this.writeObjectNotNullInternal(object, byteOrder);
            }
            return this;
        }

        private DataOutput writeObjectNotNullInternal(Object object, boolean byteOrder) {
            Preconditions.checkNotNull((Object)object);
            Class<?> type = object.getClass();
            AttributeSerializer s = StandardSerializer.this.getSerializer(type);
            if (byteOrder) {
                StandardSerializer.ensureOrderPreserving(s, type).writeByteOrder(this, object);
            } else {
                s.write(this, object);
            }
            return this;
        }

        @Override
        public DataOutput writeClassAndObject(Object object) {
            if (object == null) {
                VariableLong.writePositive(this, 0L);
            } else {
                Class<?> type = object.getClass();
                VariableLong.writePositive(this, StandardSerializer.this.getDataTypeRegistration(type));
                this.writeObjectNotNullInternal(object, false);
            }
            return this;
        }

        @Override
        public DataOutput putLong(long val) {
            super.putLong(val);
            return this;
        }

        @Override
        public DataOutput putInt(int val) {
            super.putInt(val);
            return this;
        }

        @Override
        public DataOutput putShort(short val) {
            super.putShort(val);
            return this;
        }

        @Override
        public WriteBuffer putBoolean(boolean val) {
            super.putBoolean(val);
            return this;
        }

        @Override
        public DataOutput putByte(byte val) {
            super.putByte(val);
            return this;
        }

        @Override
        public DataOutput putBytes(byte[] val) {
            super.putBytes(val);
            return this;
        }

        @Override
        public DataOutput putBytes(StaticBuffer val) {
            super.putBytes(val);
            return this;
        }

        @Override
        public DataOutput putChar(char val) {
            super.putChar(val);
            return this;
        }

        @Override
        public DataOutput putFloat(float val) {
            super.putFloat(val);
            return this;
        }

        @Override
        public DataOutput putDouble(double val) {
            super.putDouble(val);
            return this;
        }
    }
}

