/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class FloatArraySerializer
extends ArraySerializer
implements AttributeSerializer<float[]> {
    @Override
    public float[] convert(Object value) {
        return (float[])this.convertInternal(value, Float.TYPE, Float.class);
    }

    @Override
    protected Object getArray(int length) {
        return new float[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setFloat(array, pos, ((Float)value).floatValue());
    }

    @Override
    public float[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getFloats(length);
    }

    @Override
    public void write(WriteBuffer buffer, float[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (int i = 0; i < attribute.length; ++i) {
                buffer.putFloat(attribute[i]);
            }
        }
    }
}

