/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.StringSerializer;

public class StringArraySerializer
extends ArraySerializer
implements AttributeSerializer<String[]> {
    private static final StringSerializer stringSerializer = new StringSerializer();

    @Override
    public String[] convert(Object value) {
        return (String[])this.convertInternal(value, null, String.class);
    }

    @Override
    protected Object getArray(int length) {
        return new String[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.set(array, pos, (String)value);
    }

    @Override
    public String[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = stringSerializer.read(buffer);
        }
        return result;
    }

    @Override
    public void write(WriteBuffer buffer, String[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (int i = 0; i < attribute.length; ++i) {
                stringSerializer.write(buffer, attribute[i]);
            }
        }
    }
}

