/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.Order;

public class OrderList
implements Comparator<JanusGraphElement>,
Iterable<OrderEntry> {
    public static final OrderList NO_ORDER = new OrderList(){
        {
            this.makeImmutable();
        }
    };
    private List<OrderEntry> list = new ArrayList<OrderEntry>(3);
    private boolean immutable = false;

    public void add(PropertyKey key, Order order) {
        Preconditions.checkArgument((!this.immutable ? 1 : 0) != 0, (Object)"This OrderList has been closed");
        this.list.add(new OrderEntry(key, order));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public PropertyKey getKey(int position) {
        return this.list.get(position).getKey();
    }

    public Order getOrder(int position) {
        return this.list.get(position).getOrder();
    }

    public int size() {
        return this.list.size();
    }

    public boolean containsKey(PropertyKey key) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.getKey(i).equals(key)) continue;
            return true;
        }
        return false;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean hasCommonOrder() {
        Order lastOrder = null;
        for (OrderEntry oe : this.list) {
            if (lastOrder == null) {
                lastOrder = oe.order;
                continue;
            }
            if (lastOrder == oe.order) continue;
            return false;
        }
        return true;
    }

    public Order getCommonOrder() {
        Preconditions.checkArgument((boolean)this.hasCommonOrder(), (Object)"This OrderList does not have a common order");
        return this.isEmpty() ? Order.DEFAULT : this.getOrder(0);
    }

    @Override
    public Iterator<OrderEntry> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        return this.list.equals(((OrderList)oth).list);
    }

    @Override
    public int compare(JanusGraphElement o1, JanusGraphElement o2) {
        for (int i = 0; i < this.list.size(); ++i) {
            int cmp = this.list.get(i).compare(o1, o2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static class OrderEntry
    implements Comparator<JanusGraphElement> {
        private final PropertyKey key;
        private final Order order;

        public OrderEntry(PropertyKey key, Order order) {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)((Object)order));
            this.key = key;
            this.order = order;
        }

        public PropertyKey getKey() {
            return this.key;
        }

        public Order getOrder() {
            return this.order;
        }

        public int hashCode() {
            return this.key.hashCode() * 1003 + this.order.hashCode();
        }

        @Override
        public int compare(JanusGraphElement o1, JanusGraphElement o2) {
            Object v1 = o1.valueOrNull(this.key);
            Object v2 = o2.valueOrNull(this.key);
            if (v1 == null || v2 == null) {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                return -1;
            }
            return this.order.modulateNaturalOrder(((Comparable)v1).compareTo(v2));
        }

        @Override
        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null) {
                return false;
            }
            if (!this.getClass().isInstance(oth)) {
                return false;
            }
            OrderEntry o = (OrderEntry)oth;
            return this.key.equals(o.key) && this.order == o.order;
        }

        public String toString() {
            return (Object)((Object)this.order) + "(" + this.key + ")";
        }
    }
}

