/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;

public interface JanusGraphPredicate
extends BiPredicate<Object, Object> {
    public boolean isValidCondition(Object var1);

    public boolean isValidValueType(Class<?> var1);

    public boolean hasNegation();

    public JanusGraphPredicate negate();

    public boolean isQNF();

    @Override
    public boolean test(Object var1, Object var2);

    public static class Converter {
        public static final JanusGraphPredicate convertInternal(BiPredicate p) {
            if (p instanceof JanusGraphPredicate) {
                return (JanusGraphPredicate)p;
            }
            if (p instanceof Compare) {
                Compare comp = (Compare)p;
                switch (comp) {
                    case eq: {
                        return Cmp.EQUAL;
                    }
                    case neq: {
                        return Cmp.NOT_EQUAL;
                    }
                    case gt: {
                        return Cmp.GREATER_THAN;
                    }
                    case gte: {
                        return Cmp.GREATER_THAN_EQUAL;
                    }
                    case lt: {
                        return Cmp.LESS_THAN;
                    }
                    case lte: {
                        return Cmp.LESS_THAN_EQUAL;
                    }
                }
                throw new IllegalArgumentException("Unexpected comparator: " + comp);
            }
            if (p instanceof Contains) {
                Contains con = (Contains)p;
                switch (con) {
                    case within: {
                        return Contain.IN;
                    }
                    case without: {
                        return Contain.NOT_IN;
                    }
                }
                throw new IllegalArgumentException("Unexpected container: " + con);
            }
            return null;
        }

        public static final JanusGraphPredicate convert(BiPredicate p) {
            JanusGraphPredicate janusgraphPred = Converter.convertInternal(p);
            if (janusgraphPred == null) {
                throw new IllegalArgumentException("JanusGraph does not support the given predicate: " + p);
            }
            return janusgraphPred;
        }

        public static final boolean supports(BiPredicate p) {
            return Converter.convertInternal(p) != null;
        }
    }
}

