/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.query.ElementQuery;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.FixedCondition;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.ProfileObservable;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class GraphCentricQuery
extends BaseQuery
implements ElementQuery<JanusGraphElement, JointIndexQuery>,
ProfileObservable {
    private final Condition<JanusGraphElement> condition;
    private final BackendQueryHolder<JointIndexQuery> indexQuery;
    private final OrderList orders;
    private final ElementCategory resultType;

    public GraphCentricQuery(ElementCategory resultType, Condition<JanusGraphElement> condition, OrderList orders, BackendQueryHolder<JointIndexQuery> indexQuery, int limit) {
        super(limit);
        Preconditions.checkNotNull(condition);
        Preconditions.checkArgument((orders != null && orders.isImmutable() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(condition));
        Preconditions.checkNotNull((Object)((Object)resultType));
        Preconditions.checkNotNull(indexQuery);
        this.condition = condition;
        this.orders = orders;
        this.resultType = resultType;
        this.indexQuery = indexQuery;
    }

    public static final GraphCentricQuery emptyQuery(ElementCategory resultType) {
        FixedCondition<JanusGraphElement> cond = new FixedCondition<JanusGraphElement>(false);
        return new GraphCentricQuery(resultType, cond, OrderList.NO_ORDER, new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), true, false), 0);
    }

    public Condition<JanusGraphElement> getCondition() {
        return this.condition;
    }

    public ElementCategory getResultType() {
        return this.resultType;
    }

    public OrderList getOrder() {
        return this.orders;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.condition.toString()).append("]");
        if (!this.orders.isEmpty()) {
            b.append(this.getLimit());
        }
        if (this.hasLimit()) {
            b.append("(").append(this.getLimit()).append(")");
        }
        b.append(":").append(this.resultType.toString());
        return b.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.condition).append((Object)this.resultType).append((Object)this.orders).append(this.getLimit()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        GraphCentricQuery oth = (GraphCentricQuery)other;
        return this.resultType == oth.resultType && this.condition.equals(oth.condition) && this.orders.equals(oth.getOrder()) && this.getLimit() == oth.getLimit();
    }

    @Override
    public boolean isEmpty() {
        return this.getLimit() <= 0;
    }

    @Override
    public int numSubQueries() {
        return 1;
    }

    @Override
    public BackendQueryHolder<JointIndexQuery> getSubQuery(int position) {
        if (position == 0) {
            return this.indexQuery;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isSorted() {
        return !this.orders.isEmpty();
    }

    @Override
    public Comparator<JanusGraphElement> getSortOrder() {
        if (this.orders.isEmpty()) {
            return new ComparableComparator();
        }
        return this.orders;
    }

    @Override
    public boolean hasDuplicateResults() {
        return false;
    }

    @Override
    public boolean matches(JanusGraphElement element) {
        return this.condition.evaluate(element);
    }

    @Override
    public void observeWith(QueryProfiler profiler) {
        profiler.setAnnotation("condition", this.condition);
        profiler.setAnnotation("orders", this.orders);
        if (this.hasLimit()) {
            profiler.setAnnotation("limit", this.getLimit());
        }
        this.indexQuery.observeWith(profiler);
    }
}

