/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.VertexList;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.VertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.VertexLongList;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.util.datastructures.Retriever;

public class SimpleVertexQueryProcessor
implements Iterable<Entry> {
    private final VertexCentricQuery query;
    private final StandardJanusGraphTx tx;
    private final EdgeSerializer edgeSerializer;
    private final InternalVertex vertex;
    private final QueryProfiler profiler;
    private SliceQuery sliceQuery;

    public SimpleVertexQueryProcessor(VertexCentricQuery query, StandardJanusGraphTx tx) {
        Preconditions.checkArgument((boolean)query.isSimple());
        this.query = query;
        this.tx = tx;
        BackendQueryHolder<SliceQuery> bqh = query.getSubQuery(0);
        this.sliceQuery = bqh.getBackendQuery();
        this.profiler = bqh.getProfiler();
        this.vertex = query.getVertex();
        this.edgeSerializer = tx.getEdgeSerializer();
    }

    @Override
    public Iterator<Entry> iterator() {
        LimitAdjustingIterator iter = this.sliceQuery.hasLimit() && this.sliceQuery.getLimit() != this.query.getLimit() ? new LimitAdjustingIterator() : this.getBasicIterator();
        return iter;
    }

    public Iterable<JanusGraphRelation> relations() {
        return RelationConstructor.readRelation(this.vertex, this, this.tx);
    }

    public VertexList vertexIds() {
        LongArrayList list = new LongArrayList();
        long previousId = 0L;
        for (Long id : Iterables.transform((Iterable)this, (Function)new Function<Entry, Long>(){

            @Nullable
            public Long apply(@Nullable Entry entry) {
                return SimpleVertexQueryProcessor.this.edgeSerializer.readRelation(entry, true, SimpleVertexQueryProcessor.this.tx).getOtherVertexId();
            }
        })) {
            list.add(id.longValue());
            if (id >= previousId && previousId >= 0L) {
                previousId = id;
                continue;
            }
            previousId = -1L;
        }
        return new VertexLongList(this.tx, list, previousId >= 0L);
    }

    private Iterator<Entry> getBasicIterator() {
        EntryList result = this.vertex.loadRelations(this.sliceQuery, new Retriever<SliceQuery, EntryList>(){

            @Override
            public EntryList get(SliceQuery query) {
                return QueryProfiler.profile(SimpleVertexQueryProcessor.this.profiler, query, q -> SimpleVertexQueryProcessor.this.tx.getGraph().edgeQuery(SimpleVertexQueryProcessor.this.vertex.longId(), (SliceQuery)q, SimpleVertexQueryProcessor.this.tx.getTxHandle()));
            }
        });
        return result.iterator();
    }

    private final class LimitAdjustingIterator
    extends org.janusgraph.graphdb.query.LimitAdjustingIterator<Entry> {
        private LimitAdjustingIterator() {
            super(SimpleVertexQueryProcessor.this.query.getLimit(), SimpleVertexQueryProcessor.this.sliceQuery.getLimit());
        }

        @Override
        public Iterator<Entry> getNewIterator(int newLimit) {
            if (newLimit > SimpleVertexQueryProcessor.this.sliceQuery.getLimit()) {
                SimpleVertexQueryProcessor.this.sliceQuery = SimpleVertexQueryProcessor.this.sliceQuery.updateLimit(newLimit);
            }
            return SimpleVertexQueryProcessor.this.getBasicIterator();
        }
    }
}

