/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.graphson;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.relations.RelationIdentifier;

public abstract class JanusGraphSONModule
extends TinkerPopJacksonModule {
    private static final String TYPE_NAMESPACE = "janusgraph";
    private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
        {
            this.put(RelationIdentifier.class, "RelationIdentifier");
            this.put(Geoshape.class, "Geoshape");
        }
    });

    protected JanusGraphSONModule() {
        super(TYPE_NAMESPACE);
        this.addSerializer(RelationIdentifier.class, (JsonSerializer)new RelationIdentifierSerializer());
        this.addDeserializer(RelationIdentifier.class, (JsonDeserializer)new RelationIdentifierDeserializer());
    }

    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    public static class RelationIdentifierDeserializer
    extends StdDeserializer<RelationIdentifier> {
        public RelationIdentifierDeserializer() {
            super(RelationIdentifier.class);
        }

        public RelationIdentifier deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            jsonParser.nextToken();
            Map mapData = (Map)deserializationContext.readValue(jsonParser, Map.class);
            return RelationIdentifier.parse((String)mapData.get("value"));
        }
    }

    public static class RelationIdentifierSerializer
    extends StdSerializer<RelationIdentifier> {
        public RelationIdentifierSerializer() {
            super(RelationIdentifier.class);
        }

        public void serialize(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(relationIdentifier.toString());
        }

        public void serializeWithType(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            typeSerializer.writeTypePrefixForScalar((Object)relationIdentifier, jsonGenerator);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("value", relationIdentifier.toString());
            jsonGenerator.writeStringField("@class", HashMap.class.getName());
            jsonGenerator.writeEndObject();
            typeSerializer.writeTypeSuffixForScalar((Object)relationIdentifier, jsonGenerator);
        }
    }
}

