/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Ranging;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.javatuples.Pair;

public interface HasStepFolder<S, E>
extends Step<S, E> {
    public void addAll(Iterable<HasContainer> var1);

    public void orderBy(String var1, Order var2);

    public void setLimit(int var1);

    public int getLimit();

    public static boolean validJanusGraphHas(HasContainer has) {
        if (has.getPredicate() instanceof AndP) {
            List predicates = ((AndP)has.getPredicate()).getPredicates();
            return !predicates.stream().filter(p -> !HasStepFolder.validJanusGraphHas(new HasContainer(has.getKey(), p))).findAny().isPresent();
        }
        return JanusGraphPredicate.Converter.supports(has.getBiPredicate());
    }

    public static boolean validJanusGraphHas(Iterable<HasContainer> has) {
        for (HasContainer h : has) {
            if (HasStepFolder.validJanusGraphHas(h)) continue;
            return false;
        }
        return true;
    }

    public static boolean validJanusGraphOrder(OrderGlobalStep ostep, Traversal rootTraversal, boolean isVertexOrder) {
        for (Pair comp : ostep.getComparators()) {
            String key;
            if (!(comp.getValue1() instanceof ElementValueComparator)) {
                return false;
            }
            ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
            if (!(evc.getValueComparator() instanceof Order)) {
                return false;
            }
            JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(rootTraversal.asAdmin());
            PropertyKey pkey = tx.getPropertyKey(key = evc.getPropertyKey());
            if (pkey == null || !Comparable.class.isAssignableFrom(pkey.dataType())) {
                return false;
            }
            if (!isVertexOrder || pkey.cardinality() == Cardinality.SINGLE) continue;
            return false;
        }
        return true;
    }

    public static void foldInIds(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                HashSet ids = new HashSet();
                GraphStep graphStep = (GraphStep)janusgraphStep;
                for (HasContainer hasContainer : ((HasContainerHolder)currentStep).getHasContainers()) {
                    if (GraphStep.processHasContainerIds((GraphStep)graphStep, (HasContainer)hasContainer)) {
                        currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                        if (!ids.isEmpty()) {
                            ids.stream().filter(id -> Arrays.stream(graphStep.getIds()).noneMatch(id::equals)).collect(Collectors.toSet()).forEach(ids::remove);
                            if (ids.isEmpty()) {
                                break;
                            }
                        } else {
                            Arrays.stream(graphStep.getIds()).forEach(ids::add);
                        }
                    }
                    graphStep.clearIds();
                }
                graphStep.addIds(new Object[]{ids});
                if (!ids.isEmpty()) {
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void foldInHasContainer(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                List containers = ((HasContainerHolder)currentStep).getHasContainers();
                if (HasStepFolder.validJanusGraphHas(containers)) {
                    janusgraphStep.addAll(containers);
                    currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void foldInOrder(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal, boolean isVertexOrder) {
        Step currentStep = janusgraphStep.getNextStep();
        OrderGlobalStep lastOrder = null;
        while (true) {
            if (currentStep instanceof OrderGlobalStep) {
                if (lastOrder != null) {
                    lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                    traversal.removeStep((Step)lastOrder);
                }
                lastOrder = (OrderGlobalStep)currentStep;
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof HasStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
        if (lastOrder != null && HasStepFolder.validJanusGraphOrder(lastOrder, rootTraversal, isVertexOrder)) {
            for (Pair comp : lastOrder.getComparators()) {
                ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                janusgraphStep.orderBy(evc.getPropertyKey(), (Order)evc.getValueComparator());
            }
            lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
            traversal.removeStep((Step)lastOrder);
        }
    }

    public static void splitAndP(List<HasContainer> hasContainers, Iterable<HasContainer> has) {
        has.forEach(hasContainer -> {
            if (hasContainer.getPredicate() instanceof AndP) {
                for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                    hasContainers.add(new HasContainer(hasContainer.getKey(), predicate));
                }
            } else {
                hasContainers.add((HasContainer)hasContainer);
            }
        });
    }

    public static <E extends Ranging> void foldInRange(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal) {
        Step nextStep = JanusGraphTraversalUtil.getNextNonIdentityStep(janusgraphStep);
        if (nextStep instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)nextStep;
            int limit = QueryUtil.convertLimit(range.getHighRange());
            janusgraphStep.setLimit(QueryUtil.mergeLimits(limit, janusgraphStep.getLimit()));
            if (range.getLowRange() == 0L) {
                nextStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                traversal.removeStep(nextStep);
            }
        }
    }

    public static class OrderEntry {
        public final String key;
        public final Order order;

        public OrderEntry(String key, Order order) {
            this.key = key;
            this.order = order;
        }
    }
}

