/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasStepFolder<S, E>,
Profiling,
HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private int limit = Integer.MAX_VALUE;
    private List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;

    public JanusGraphStep(GraphStep<S, E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.isStartStep(), originalStep.getIds());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> {
            if (this.ids != null && this.ids.length > 0) {
                Graph graph = (Graph)this.traversal.asAdmin().getGraph().get();
                return this.iteratorList(graph.vertices(this.ids));
            }
            JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(this.traversal);
            JanusGraphQuery<? extends JanusGraphQuery> query = tx.query();
            for (HasContainer condition : this.hasContainers) {
                query.has(condition.getKey(), JanusGraphPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
            }
            for (HasStepFolder.OrderEntry order : this.orders) {
                query.orderBy(order.key, order.order);
            }
            if (this.limit != Integer.MAX_VALUE) {
                query.limit(this.limit);
            }
            ((GraphCentricQueryBuilder)query).profiler(this.queryProfiler);
            return Vertex.class.isAssignableFrom(this.returnClass) ? query.vertices().iterator() : query.edges().iterator();
        });
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), this.hasContainers});
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        HasStepFolder.splitAndP(this.hasContainers, has);
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public List<HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    public void addHasContainer(HasContainer hasContainer) {
        this.addAll(Collections.singleton(hasContainer));
    }

    private <E extends Element> Iterator<E> iteratorList(Iterator<E> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Element)e, this.hasContainers)) continue;
            list.add(e);
        }
        return list.iterator();
    }
}

