/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.addedrelations;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;

public class SimpleBufferAddedRelations
implements AddedRelationsContainer {
    private static final int INITIAL_ADDED_SIZE = 10;
    private static final int INITIAL_DELETED_SIZE = 10;
    private static final int MAX_DELETED_SIZE = 500;
    private List<InternalRelation> added = new ArrayList<InternalRelation>(10);
    private List<InternalRelation> deleted = null;

    @Override
    public boolean add(InternalRelation relation) {
        return this.added.add(relation);
    }

    @Override
    public boolean remove(InternalRelation relation) {
        if (this.added.isEmpty()) {
            return false;
        }
        if (this.deleted == null) {
            this.deleted = new ArrayList<InternalRelation>(10);
        }
        boolean del = this.deleted.add(relation);
        if (this.deleted.size() > 500) {
            this.cleanup();
        }
        return del;
    }

    @Override
    public boolean isEmpty() {
        this.cleanup();
        return this.added.isEmpty();
    }

    private void cleanup() {
        if (this.deleted == null || this.deleted.isEmpty()) {
            return;
        }
        HashSet<InternalRelation> deletedSet = new HashSet<InternalRelation>(this.deleted);
        this.deleted = null;
        ArrayList<InternalRelation> newadded = new ArrayList<InternalRelation>(this.added.size() - deletedSet.size() / 2);
        for (InternalRelation r : this.added) {
            if (deletedSet.contains(r)) continue;
            newadded.add(r);
        }
        this.added = newadded;
    }

    @Override
    public List<InternalRelation> getView(Predicate<InternalRelation> filter) {
        this.cleanup();
        ArrayList<InternalRelation> result = new ArrayList<InternalRelation>();
        for (InternalRelation r : this.added) {
            if (!filter.apply((Object)r)) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public Collection<InternalRelation> getAll() {
        this.cleanup();
        return this.added;
    }
}

