/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.schema.Parameter;

public enum ParameterType {
    MAPPING("mapping"),
    INDEX_POSITION("index-pos"),
    MAPPED_NAME("mapped-name"),
    STATUS("status"),
    INDEX_GEO_MAX_LEVELS("index-geo-max-levels"),
    INDEX_GEO_DIST_ERROR_PCT("index-geo-dist-error-pct"),
    STRING_ANALYZER("string-analyzer"),
    TEXT_ANALYZER("text-analyzer");

    private final String name;

    private ParameterType(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public <V> V findParameter(Parameter[] parameters, V defaultValue) {
        V result = null;
        for (Parameter p : parameters) {
            if (!p.key().equalsIgnoreCase(this.name)) continue;
            Object value = p.value();
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Invalid mapping specified: %s", (Object[])new Object[]{value});
            Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"Multiple mappings specified");
            result = value;
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean hasParameter(Parameter[] parameters) {
        return this.findParameter(parameters, null) != null;
    }

    public <V> Parameter<V> getParameter(V value) {
        return new Parameter<V>(this.name, value);
    }
}

