/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

public class Threads {
    public static final int DEFAULT_SLEEP_INTERVAL_MS = 100;

    public static final boolean oneAlife(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    public static final void terminate(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive()) continue;
            threads[i].interrupt();
        }
    }

    public static final boolean waitForCompletion(Thread[] threads) {
        return Threads.waitForCompletion(threads, Integer.MAX_VALUE);
    }

    public static final boolean waitForCompletion(Thread[] threads, int maxWaitMillis) {
        return Threads.waitForCompletion(threads, maxWaitMillis, 100);
    }

    public static final boolean waitForCompletion(Thread[] threads, int maxWaitMillis, int sleepPeriodMillis) {
        long endTime = System.currentTimeMillis() + (long)maxWaitMillis;
        while (Threads.oneAlife(threads)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= endTime) {
                return false;
            }
            try {
                Thread.sleep(Math.min((long)sleepPeriodMillis, endTime - currentTime));
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while waiting for completion of threads!");
            }
        }
        return true;
    }
}

