/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.system.BaseKey;

public class Connection {
    private final VertexLabel incomingVertexLabel;
    private final VertexLabel outgoingVertexLabel;
    private final String edgeLabel;
    private final JanusGraphEdge connectionEdge;

    public Connection(JanusGraphEdge connectionEdge) {
        this.outgoingVertexLabel = (VertexLabel)connectionEdge.outVertex();
        this.incomingVertexLabel = (VertexLabel)connectionEdge.inVertex();
        TypeDefinitionDescription value = (TypeDefinitionDescription)connectionEdge.valueOrNull(BaseKey.SchemaDefinitionDesc);
        this.edgeLabel = (String)value.getModifier();
        this.connectionEdge = connectionEdge;
    }

    public Connection(String edgeLabel, VertexLabel outgoingVertexLabel, VertexLabel incomingVertexLabel) {
        this.outgoingVertexLabel = outgoingVertexLabel;
        this.incomingVertexLabel = incomingVertexLabel;
        this.edgeLabel = edgeLabel;
        this.connectionEdge = null;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public VertexLabel getOutgoingVertexLabel() {
        return this.outgoingVertexLabel;
    }

    public VertexLabel getIncomingVertexLabel() {
        return this.incomingVertexLabel;
    }

    public JanusGraphEdge getConnectionEdge() {
        return this.connectionEdge;
    }
}

