/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.IDAuthority;
import org.janusgraph.diskstorage.StandardIndexProvider;
import org.janusgraph.diskstorage.StandardStoreManager;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.configuration.backend.KCVSConfiguration;
import org.janusgraph.diskstorage.configuration.backend.builder.KCVSConfigurationBuilder;
import org.janusgraph.diskstorage.idmanagement.ConsistentKeyIDAuthority;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CacheTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.ExpirationKCVSCache;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.keycolumnvalue.cache.NoKCVSCache;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManagerAdapter;
import org.janusgraph.diskstorage.keycolumnvalue.scan.StandardScanner;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.LockerProvider;
import org.janusgraph.diskstorage.locking.consistentkey.ConsistentKeyLocker;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingStoreManager;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.LogManager;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.diskstorage.util.MetricInstrumentedStoreManager;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backend
implements LockerProvider,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Backend.class);
    public static final String EDGESTORE_NAME = "edgestore";
    public static final String INDEXSTORE_NAME = "graphindex";
    public static final String METRICS_STOREMANAGER_NAME = "storeManager";
    public static final String METRICS_MERGED_STORE = "stores";
    public static final String METRICS_MERGED_CACHE = "caches";
    public static final String METRICS_CACHE_SUFFIX = ".cache";
    public static final String LOCK_STORE_SUFFIX = "_lock_";
    public static final String SYSTEM_TX_LOG_NAME = "txlog";
    public static final String SYSTEM_MGMT_LOG_NAME = "systemlog";
    public static final double EDGESTORE_CACHE_PERCENT = 0.8;
    public static final double INDEXSTORE_CACHE_PERCENT = 0.2;
    private static final long ETERNAL_CACHE_EXPIRATION = 6307200000000L;
    public static final int THREAD_POOL_SIZE_SCALE_FACTOR = 2;
    private final KeyColumnValueStoreManager storeManager;
    private final KeyColumnValueStoreManager storeManagerLocking;
    private final StoreFeatures storeFeatures;
    private KCVSCache edgeStore;
    private KCVSCache indexStore;
    private KCVSCache txLogStore;
    private IDAuthority idAuthority;
    private KCVSConfiguration systemConfig;
    private KCVSConfiguration userConfig;
    private boolean hasAttemptedClose;
    private final StandardScanner scanner;
    private final KCVSLogManager managementLogManager;
    private final KCVSLogManager txLogManager;
    private final LogManager userLogManager;
    private final Map<String, IndexProvider> indexes;
    private final int bufferSize;
    private final Duration maxWriteTime;
    private final Duration maxReadTime;
    private final boolean cacheEnabled;
    private final ExecutorService threadPool;
    private final Function<String, Locker> lockerCreator;
    private final ConcurrentHashMap<String, Locker> lockers = new ConcurrentHashMap();
    private final Configuration configuration;
    private static final ImmutableMap<StandardStoreManager, ConfigOption<?>> STORE_SHORTHAND_OPTIONS;
    public static final Map<String, String> REGISTERED_LOG_MANAGERS;
    private final Function<String, Locker> CONSISTENT_KEY_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            KeyColumnValueStore lockerStore;
            try {
                lockerStore = Backend.this.storeManager.openDatabase(lockerName);
            }
            catch (BackendException e) {
                throw new JanusGraphConfigurationException("Could not retrieve store named " + lockerName + " for locker configuration", e);
            }
            return new ConsistentKeyLocker.Builder(lockerStore, Backend.this.storeManager).fromConfig(Backend.this.configuration).build();
        }
    };
    private final Function<String, Locker> ASTYANAX_RECIPE_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            String expectedManagerName = "org.janusgraph.diskstorage.cassandra.astyanax.AstyanaxStoreManager";
            String actualManagerName = Backend.this.storeManager.getClass().getCanonicalName();
            Preconditions.checkArgument((boolean)expectedManagerName.equals(actualManagerName), (Object)("Astyanax Recipe locker is only supported with the Astyanax storage backend (configured:" + actualManagerName + " != required:" + expectedManagerName + ")"));
            try {
                Class<?> c = Backend.this.storeManager.getClass();
                Method method = c.getMethod("openLocker", String.class);
                Object o = method.invoke((Object)Backend.this.storeManager, lockerName);
                return (Locker)o;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find method when configuring locking with Astyanax Recipes");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access method when configuring locking with Astyanax Recipes", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke method when configuring locking with Astyanax Recipes", e);
            }
        }
    };
    private static final Function<String, Locker> TEST_LOCKER_CREATOR;
    private final Map<String, Function<String, Locker>> REGISTERED_LOCKERS = ImmutableMap.of((Object)"consistentkey", this.CONSISTENT_KEY_LOCKER_CREATOR, (Object)"astyanaxrecipe", this.ASTYANAX_RECIPE_LOCKER_CREATOR, (Object)"test", TEST_LOCKER_CREATOR);

    public Backend(Configuration configuration) {
        this.configuration = configuration;
        KeyColumnValueStoreManager manager = Backend.getStorageManager(configuration);
        this.storeManager = configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]) != false ? new MetricInstrumentedStoreManager(manager, METRICS_STOREMANAGER_NAME, configuration.get(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]), METRICS_MERGED_STORE) : manager;
        this.indexes = Backend.getIndexes(configuration);
        this.storeFeatures = this.storeManager.getFeatures();
        this.managementLogManager = this.getKCVSLogManager("janusgraph");
        this.txLogManager = this.getKCVSLogManager("tx");
        this.userLogManager = this.getLogManager("user");
        this.cacheEnabled = configuration.get(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]) == false && configuration.get(GraphDatabaseConfiguration.DB_CACHE, new String[0]) != false;
        int bufferSizeTmp = configuration.get(GraphDatabaseConfiguration.BUFFER_SIZE, new String[0]);
        Preconditions.checkArgument((bufferSizeTmp > 0 ? 1 : 0) != 0, (Object)"Buffer size must be positive");
        this.bufferSize = !this.storeFeatures.hasBatchMutation() ? Integer.MAX_VALUE : bufferSizeTmp;
        this.maxWriteTime = configuration.get(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]);
        this.maxReadTime = configuration.get(GraphDatabaseConfiguration.STORAGE_READ_WAITTIME, new String[0]);
        if (!this.storeFeatures.hasLocking()) {
            Preconditions.checkArgument((boolean)this.storeFeatures.isKeyConsistent(), (Object)"Store needs to support some form of locking");
            this.storeManagerLocking = new ExpectedValueCheckingStoreManager(this.storeManager, LOCK_STORE_SUFFIX, this, this.maxReadTime);
        } else {
            this.storeManagerLocking = this.storeManager;
        }
        if (configuration.get(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS, new String[0]).booleanValue()) {
            int poolSize = Runtime.getRuntime().availableProcessors() * 2;
            this.threadPool = Executors.newFixedThreadPool(poolSize);
            log.info("Initiated backend operations thread pool of size {}", (Object)poolSize);
        } else {
            this.threadPool = null;
        }
        String lockBackendName = configuration.get(GraphDatabaseConfiguration.LOCK_BACKEND, new String[0]);
        if (!this.REGISTERED_LOCKERS.containsKey(lockBackendName)) {
            throw new JanusGraphConfigurationException("Unknown lock backend \"" + lockBackendName + "\".  Known lock backends: " + Joiner.on((String)", ").join(this.REGISTERED_LOCKERS.keySet()) + ".");
        }
        this.lockerCreator = this.REGISTERED_LOCKERS.get(lockBackendName);
        Preconditions.checkNotNull(this.lockerCreator);
        this.scanner = new StandardScanner(this.storeManager);
    }

    @Override
    public Locker getLocker(String lockerName) {
        Locker x;
        Preconditions.checkNotNull((Object)lockerName);
        Locker l = this.lockers.get(lockerName);
        if (null == l && null != (x = this.lockers.putIfAbsent(lockerName, l = (Locker)this.lockerCreator.apply((Object)lockerName)))) {
            l = x;
        }
        return l;
    }

    public void initialize(Configuration config) {
        try {
            KeyColumnValueStore idStore = this.storeManager.openDatabase(config.get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]));
            this.idAuthority = null;
            if (!this.storeFeatures.isKeyConsistent()) {
                throw new IllegalStateException("Store needs to support consistent key or transactional operations for ID manager to guarantee proper id allocations");
            }
            this.idAuthority = new ConsistentKeyIDAuthority(idStore, this.storeManager, config);
            KeyColumnValueStore edgeStoreRaw = this.storeManagerLocking.openDatabase(EDGESTORE_NAME);
            KeyColumnValueStore indexStoreRaw = this.storeManagerLocking.openDatabase(INDEXSTORE_NAME);
            if (this.cacheEnabled) {
                long cacheSizeBytes;
                double cacheSize;
                long expirationTime = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]);
                Preconditions.checkArgument((expirationTime >= 0L ? 1 : 0) != 0, (String)"Invalid cache expiration time: %s", (Object[])new Object[]{expirationTime});
                if (expirationTime == 0L) {
                    expirationTime = 6307200000000L;
                }
                Preconditions.checkArgument(((cacheSize = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_SIZE, new String[0]).doubleValue()) > 0.0 ? 1 : 0) != 0, (String)"Invalid cache size specified: %s", (Object[])new Object[]{cacheSize});
                if (cacheSize < 1.0) {
                    Runtime runtime = Runtime.getRuntime();
                    cacheSizeBytes = (long)((double)(runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) * cacheSize);
                } else {
                    Preconditions.checkArgument((cacheSize > 1000.0 ? 1 : 0) != 0, (String)"Cache size is too small: %s", (Object[])new Object[]{cacheSize});
                    cacheSizeBytes = (long)cacheSize;
                }
                log.info("Configuring total store cache size: {}", (Object)cacheSizeBytes);
                long cleanWaitTime = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]).intValue();
                Preconditions.checkArgument((boolean)true, (Object)"Cache percentages don't add up!");
                long edgeStoreCacheSize = Math.round((double)cacheSizeBytes * 0.8);
                long indexStoreCacheSize = Math.round((double)cacheSizeBytes * 0.2);
                this.edgeStore = new ExpirationKCVSCache(edgeStoreRaw, this.getMetricsCacheName(EDGESTORE_NAME), expirationTime, cleanWaitTime, edgeStoreCacheSize);
                this.indexStore = new ExpirationKCVSCache(indexStoreRaw, this.getMetricsCacheName(INDEXSTORE_NAME), expirationTime, cleanWaitTime, indexStoreCacheSize);
            } else {
                this.edgeStore = new NoKCVSCache(edgeStoreRaw);
                this.indexStore = new NoKCVSCache(indexStoreRaw);
            }
            this.txLogManager.openLog(SYSTEM_TX_LOG_NAME);
            this.managementLogManager.openLog(SYSTEM_MGMT_LOG_NAME);
            this.txLogStore = new NoKCVSCache(this.storeManager.openDatabase(SYSTEM_TX_LOG_NAME));
            KeyColumnValueStore systemConfigStore = this.storeManagerLocking.openDatabase("system_properties");
            KCVSConfigurationBuilder kcvsConfigurationBuilder = new KCVSConfigurationBuilder();
            this.systemConfig = kcvsConfigurationBuilder.buildGlobalConfiguration(new BackendOperation.TransactionalProvider(){

                @Override
                public StoreTransaction openTx() throws BackendException {
                    return Backend.this.storeManagerLocking.beginTransaction(StandardBaseTransactionConfig.of(Backend.this.configuration.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]), Backend.this.storeFeatures.getKeyConsistentTxConfig()));
                }

                @Override
                public void close() throws BackendException {
                }
            }, systemConfigStore, this.configuration);
            this.userConfig = kcvsConfigurationBuilder.buildConfiguration(new BackendOperation.TransactionalProvider(){

                @Override
                public StoreTransaction openTx() throws BackendException {
                    return Backend.this.storeManagerLocking.beginTransaction(StandardBaseTransactionConfig.of(Backend.this.configuration.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0])));
                }

                @Override
                public void close() throws BackendException {
                }
            }, systemConfigStore, "userconfig", this.configuration);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not initialize backend", e);
        }
    }

    public Map<String, IndexInformation> getIndexInformation() {
        ImmutableMap.Builder copy = ImmutableMap.builder();
        copy.putAll(this.indexes);
        return copy.build();
    }

    public KCVSLog getSystemTxLog() {
        try {
            return this.txLogManager.openLog(SYSTEM_TX_LOG_NAME);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not re-open transaction log", e);
        }
    }

    public Log getSystemMgmtLog() {
        try {
            return this.managementLogManager.openLog(SYSTEM_MGMT_LOG_NAME);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not re-open management log", e);
        }
    }

    public StandardScanner.Builder buildEdgeScanJob() {
        return this.buildStoreIndexScanJob(EDGESTORE_NAME);
    }

    public StandardScanner.Builder buildGraphIndexScanJob() {
        return this.buildStoreIndexScanJob(INDEXSTORE_NAME);
    }

    private StandardScanner.Builder buildStoreIndexScanJob(String storeName) {
        TimestampProvider provider = this.configuration.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
        ModifiableConfiguration jobConfig = this.buildJobConfiguration();
        jobConfig.set(GraphDatabaseConfiguration.JOB_START_TIME, provider.getTime().toEpochMilli(), new String[0]);
        return this.scanner.build().setStoreName(storeName).setTimestampProvider(provider).setJobConfiguration(jobConfig).setGraphConfiguration(this.configuration).setNumProcessingThreads(1).setWorkBlockSize(10000);
    }

    public JanusGraphManagement.IndexJobFuture getScanJobStatus(Object jobId) {
        return this.scanner.getRunningJob(jobId);
    }

    public Log getUserLog(String identifier) throws BackendException {
        return this.userLogManager.openLog(Backend.getUserLogName(identifier));
    }

    public static String getUserLogName(String identifier) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier));
        return "ulog_" + identifier;
    }

    public KCVSConfiguration getGlobalSystemConfig() {
        return this.systemConfig;
    }

    public KCVSConfiguration getUserConfiguration() {
        return this.userConfig;
    }

    private String getMetricsCacheName(String storeName) {
        if (!this.configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]).booleanValue()) {
            return null;
        }
        return this.configuration.get(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]) != false ? METRICS_MERGED_CACHE : storeName + METRICS_CACHE_SUFFIX;
    }

    public KCVSLogManager getKCVSLogManager(String logName) {
        Preconditions.checkArgument((boolean)this.configuration.restrictTo(logName).get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0]).equalsIgnoreCase(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()));
        return (KCVSLogManager)this.getLogManager(logName);
    }

    public LogManager getLogManager(String logName) {
        return Backend.getLogManager(this.configuration, logName, this.storeManager);
    }

    private static LogManager getLogManager(Configuration config, String logName, KeyColumnValueStoreManager sm) {
        Configuration logConfig = config.restrictTo(logName);
        String backend = logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0]);
        if (backend.equalsIgnoreCase(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue())) {
            return new KCVSLogManager(sm, logConfig);
        }
        Preconditions.checkArgument((config != null ? 1 : 0) != 0);
        LogManager lm = (LogManager)Backend.getImplementationClass(logConfig, logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0]), REGISTERED_LOG_MANAGERS);
        Preconditions.checkNotNull((Object)lm);
        return lm;
    }

    public static KeyColumnValueStoreManager getStorageManager(Configuration storageConfig) {
        StoreManager manager = (StoreManager)Backend.getImplementationClass(storageConfig, storageConfig.get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0]), StandardStoreManager.getAllManagerClasses());
        if (manager instanceof OrderedKeyValueStoreManager) {
            manager = new OrderedKeyValueStoreManagerAdapter((OrderedKeyValueStoreManager)manager, (Map<String, Integer>)ImmutableMap.of((Object)EDGESTORE_NAME, (Object)8, (Object)"edgestore_lock_", (Object)8, (Object)storageConfig.get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]), (Object)8));
        }
        Preconditions.checkArgument((boolean)(manager instanceof KeyColumnValueStoreManager), (String)"Invalid storage manager: %s", (Object[])new Object[]{manager.getClass()});
        return (KeyColumnValueStoreManager)manager;
    }

    private static Map<String, IndexProvider> getIndexes(Configuration config) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String index : config.getContainedNamespaces(GraphDatabaseConfiguration.INDEX_NS, new String[0])) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)index), (String)"Invalid index name [%s]", (Object[])new Object[]{index});
            log.info("Configuring index [{}]", (Object)index);
            IndexProvider provider = (IndexProvider)Backend.getImplementationClass(config.restrictTo(index), config.get(GraphDatabaseConfiguration.INDEX_BACKEND, index), StandardIndexProvider.getAllProviderClasses());
            Preconditions.checkNotNull((Object)provider);
            builder.put((Object)index, (Object)provider);
        }
        return builder.build();
    }

    public static <T> T getImplementationClass(Configuration config, String className, Map<String, String> registeredImplementations) {
        if (registeredImplementations.containsKey(className.toLowerCase())) {
            className = registeredImplementations.get(className.toLowerCase());
        }
        return ConfigurationUtil.instantiate(className, new Object[]{config}, new Class[]{Configuration.class});
    }

    public IDAuthority getIDAuthority() {
        Preconditions.checkNotNull((Object)this.idAuthority, (Object)"Backend has not yet been initialized");
        return this.idAuthority;
    }

    public StoreFeatures getStoreFeatures() {
        return this.storeFeatures;
    }

    public Class<? extends KeyColumnValueStoreManager> getStoreManagerClass() {
        return this.storeManager.getClass();
    }

    public StoreManager getStoreManager() {
        return this.storeManager;
    }

    public Map<String, IndexFeatures> getIndexFeatures() {
        return Maps.transformValues(this.indexes, (Function)new Function<IndexProvider, IndexFeatures>(){

            @Nullable
            public IndexFeatures apply(@Nullable IndexProvider indexProvider) {
                return indexProvider.getFeatures();
            }
        });
    }

    public BackendTransaction beginTransaction(TransactionConfiguration configuration, KeyInformation.Retriever indexKeyRetriever) throws BackendException {
        StoreTransaction tx = this.storeManagerLocking.beginTransaction(configuration);
        CacheTransaction cacheTx = new CacheTransaction(tx, this.storeManagerLocking, this.bufferSize, this.maxWriteTime, configuration.hasEnabledBatchLoading());
        HashMap<String, IndexTransaction> indexTx = new HashMap<String, IndexTransaction>(this.indexes.size());
        for (Map.Entry<String, IndexProvider> entry : this.indexes.entrySet()) {
            indexTx.put(entry.getKey(), new IndexTransaction(entry.getValue(), indexKeyRetriever.get(entry.getKey()), configuration, this.maxWriteTime));
        }
        return new BackendTransaction(cacheTx, configuration, this.storeFeatures, this.edgeStore, this.indexStore, this.txLogStore, this.maxReadTime, indexTx, this.threadPool);
    }

    @Override
    public synchronized void close() throws BackendException {
        if (!this.hasAttemptedClose) {
            this.hasAttemptedClose = true;
            this.managementLogManager.close();
            this.txLogManager.close();
            this.userLogManager.close();
            this.scanner.close();
            if (this.edgeStore != null) {
                this.edgeStore.close();
            }
            if (this.indexStore != null) {
                this.indexStore.close();
            }
            if (this.idAuthority != null) {
                this.idAuthority.close();
            }
            if (this.systemConfig != null) {
                this.systemConfig.close();
            }
            if (this.userConfig != null) {
                this.userConfig.close();
            }
            this.storeManager.close();
            if (this.threadPool != null) {
                this.threadPool.shutdown();
            }
            for (IndexProvider index : this.indexes.values()) {
                index.close();
            }
        } else {
            log.debug("Backend {} has already been closed or cleared", (Object)this);
        }
    }

    public synchronized void clearStorage() throws BackendException {
        if (!this.hasAttemptedClose) {
            this.hasAttemptedClose = true;
            this.managementLogManager.close();
            this.txLogManager.close();
            this.userLogManager.close();
            this.scanner.close();
            this.edgeStore.close();
            this.indexStore.close();
            this.idAuthority.close();
            this.systemConfig.close();
            this.userConfig.close();
            this.storeManager.clearStorage();
            this.storeManager.close();
            for (IndexProvider index : this.indexes.values()) {
                index.clearStorage();
                index.close();
            }
        } else {
            log.debug("Backend {} has already been closed or cleared", (Object)this);
        }
    }

    private ModifiableConfiguration buildJobConfiguration() {
        return new ModifiableConfiguration(GraphDatabaseConfiguration.JOB_NS, new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
    }

    public static ConfigOption<?> getOptionForShorthand(String shorthand) {
        if (null == shorthand) {
            return null;
        }
        shorthand = shorthand.toLowerCase();
        for (StandardStoreManager m : STORE_SHORTHAND_OPTIONS.keySet()) {
            if (!m.getShorthands().contains(shorthand)) continue;
            return (ConfigOption)STORE_SHORTHAND_OPTIONS.get((Object)m);
        }
        return null;
    }

    private static Locker openManagedLocker(String classname, String lockerName) {
        try {
            Class<?> c = Class.forName(classname);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Method method = c.getMethod("openLocker", String.class);
            Object o = method.invoke(instance, lockerName);
            return (Locker)o;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + classname);
        }
        catch (ClassCastException | InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find method when configuring locking for: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access method when configuring locking for: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not invoke method when configuring locking for: " + classname, e);
        }
    }

    static {
        HashMap<StandardStoreManager, ConfigOption<Object>> m = new HashMap<StandardStoreManager, ConfigOption<Object>>();
        m.put(StandardStoreManager.BDB_JE, GraphDatabaseConfiguration.STORAGE_DIRECTORY);
        m.put(StandardStoreManager.CASSANDRA_ASTYANAX, GraphDatabaseConfiguration.STORAGE_HOSTS);
        m.put(StandardStoreManager.CASSANDRA_EMBEDDED, GraphDatabaseConfiguration.STORAGE_CONF_FILE);
        m.put(StandardStoreManager.CASSANDRA_THRIFT, GraphDatabaseConfiguration.STORAGE_HOSTS);
        m.put(StandardStoreManager.HBASE, GraphDatabaseConfiguration.STORAGE_HOSTS);
        STORE_SHORTHAND_OPTIONS = ImmutableMap.copyOf(m);
        REGISTERED_LOG_MANAGERS = new HashMap<String, String>(){
            {
                this.put("default", "org.janusgraph.diskstorage.log.kcvs.KCVSLogManager");
            }
        };
        TEST_LOCKER_CREATOR = lockerName -> Backend.openManagedLocker("org.janusgraph.diskstorage.util.TestLockerManager", lockerName);
    }
}

