/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum StandardStoreManager {
    BDB_JE("org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager", "berkeleyje"),
    CASSANDRA_THRIFT("org.janusgraph.diskstorage.cassandra.thrift.CassandraThriftStoreManager", "cassandrathrift"),
    CASSANDRA_ASTYANAX("org.janusgraph.diskstorage.cassandra.astyanax.AstyanaxStoreManager", (ImmutableList<String>)ImmutableList.of((Object)"cassandra", (Object)"astyanax")),
    CASSANDRA_EMBEDDED("org.janusgraph.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager", "embeddedcassandra"),
    CQL("org.janusgraph.diskstorage.cql.CQLStoreManager", "cql"),
    HBASE("org.janusgraph.diskstorage.hbase.HBaseStoreManager", "hbase"),
    IN_MEMORY("org.janusgraph.diskstorage.keycolumnvalue.inmemory.InMemoryStoreManager", "inmemory");

    private final String managerClass;
    private final ImmutableList<String> shorthands;
    private static final ImmutableList<String> ALL_SHORTHANDS;
    private static final ImmutableMap<String, String> ALL_MANAGER_CLASSES;

    private StandardStoreManager(String managerClass, ImmutableList<String> shorthands) {
        this.managerClass = managerClass;
        this.shorthands = shorthands;
    }

    private StandardStoreManager(String managerClass, String shorthand) {
        this(managerClass, (ImmutableList<String>)ImmutableList.of((Object)shorthand));
    }

    public List<String> getShorthands() {
        return this.shorthands;
    }

    public String getManagerClass() {
        return this.managerClass;
    }

    public static List<String> getAllShorthands() {
        return ALL_SHORTHANDS;
    }

    public static Map<String, String> getAllManagerClasses() {
        return ALL_MANAGER_CLASSES;
    }

    static {
        StandardStoreManager[] backends = StandardStoreManager.values();
        ArrayList<String> tempShorthands = new ArrayList<String>();
        HashMap<String, String> tempClassMap = new HashMap<String, String>();
        for (StandardStoreManager backend : backends) {
            tempShorthands.addAll(backend.getShorthands());
            for (String shorthand : backend.getShorthands()) {
                tempClassMap.put(shorthand, backend.getManagerClass());
            }
        }
        ALL_SHORTHANDS = ImmutableList.copyOf(tempShorthands);
        ALL_MANAGER_CLASSES = ImmutableMap.copyOf(tempClassMap);
    }
}

