/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.LoggableTransaction;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.util.StreamIterable;

public class IndexTransaction
implements BaseTransaction,
LoggableTransaction {
    private static final int DEFAULT_OUTER_MAP_SIZE = 3;
    private static final int DEFAULT_INNER_MAP_SIZE = 5;
    private final IndexProvider index;
    private final BaseTransaction indexTx;
    private final KeyInformation.IndexRetriever keyInformation;
    private final Duration maxWriteTime;
    private Map<String, Map<String, IndexMutation>> mutations;

    public IndexTransaction(IndexProvider index, KeyInformation.IndexRetriever keyInformation, BaseTransactionConfig config, Duration maxWriteTime) throws BackendException {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkNotNull((Object)keyInformation);
        this.index = index;
        this.keyInformation = keyInformation;
        this.indexTx = index.beginTransaction(config);
        Preconditions.checkNotNull((Object)this.indexTx);
        this.maxWriteTime = maxWriteTime;
        this.mutations = new HashMap<String, Map<String, IndexMutation>>(3);
    }

    public void add(String store, String documentId, IndexEntry entry, boolean isNew) {
        this.getIndexMutation(store, documentId, isNew, false).addition(new IndexEntry(entry.field, entry.value, entry.getMetaData()));
    }

    public void add(String store, String documentId, String key, Object value, boolean isNew) {
        this.getIndexMutation(store, documentId, isNew, false).addition(new IndexEntry(key, value));
    }

    public void delete(String store, String documentId, String key, Object value, boolean deleteAll) {
        this.getIndexMutation(store, documentId, false, deleteAll).deletion(new IndexEntry(key, value));
    }

    private IndexMutation getIndexMutation(String store, String documentId, boolean isNew, boolean isDeleted) {
        Map storeMutations = this.mutations.computeIfAbsent(store, k -> new HashMap(5));
        IndexMutation m = (IndexMutation)storeMutations.get(documentId);
        if (m == null) {
            m = new IndexMutation(this.keyInformation.get(store), isNew, isDeleted);
            storeMutations.put(documentId, m);
        } else if (isNew && m.isDeleted()) {
            m.resetDelete();
            assert (!m.isNew() && !m.isDeleted());
        }
        return m;
    }

    public void register(String store, String key, KeyInformation information) throws BackendException {
        this.index.register(store, key, information, this.indexTx);
    }

    @Deprecated
    public List<String> query(IndexQuery query) throws BackendException {
        return this.queryStream(query).collect(Collectors.toList());
    }

    public Stream<String> queryStream(IndexQuery query) throws BackendException {
        return this.index.query(query, this.keyInformation, this.indexTx);
    }

    @Deprecated
    public Iterable<RawQuery.Result<String>> query(RawQuery query) throws BackendException {
        return new StreamIterable<RawQuery.Result<String>>(this.index.query(query, this.keyInformation, this.indexTx));
    }

    public Stream<RawQuery.Result<String>> queryStream(RawQuery query) throws BackendException {
        return this.index.query(query, this.keyInformation, this.indexTx);
    }

    public Long totals(RawQuery query) throws BackendException {
        return this.index.totals(query, this.keyInformation, this.indexTx);
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents) throws BackendException {
        this.index.restore(documents, this.keyInformation, this.indexTx);
    }

    @Override
    public void commit() throws BackendException {
        this.flushInternal();
        this.indexTx.commit();
    }

    @Override
    public void rollback() throws BackendException {
        this.mutations = null;
        this.indexTx.rollback();
    }

    private void flushInternal() throws BackendException {
        if (this.mutations != null && !this.mutations.isEmpty()) {
            for (Map<String, IndexMutation> store : this.mutations.values()) {
                for (IndexMutation mut : store.values()) {
                    mut.consolidate();
                }
            }
            BackendOperation.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IndexTransaction.this.index.mutate(IndexTransaction.this.mutations, IndexTransaction.this.keyInformation, IndexTransaction.this.indexTx);
                    return true;
                }

                public String toString() {
                    return "IndexMutation";
                }
            }, this.maxWriteTime);
            this.mutations = null;
        }
    }

    @Override
    public void logMutations(DataOutput out) {
        VariableLong.writePositive(out, this.mutations.size());
        for (Map.Entry<String, Map<String, IndexMutation>> store : this.mutations.entrySet()) {
            out.writeObjectNotNull(store.getKey());
            VariableLong.writePositive(out, store.getValue().size());
            for (Map.Entry<String, IndexMutation> doc : store.getValue().entrySet()) {
                out.writeObjectNotNull(doc.getKey());
                IndexMutation mut = doc.getValue();
                out.putByte((byte)(mut.isNew() ? 1 : (mut.isDeleted() ? 2 : 0)));
                List additions = mut.getAdditions();
                VariableLong.writePositive(out, additions.size());
                for (IndexEntry add : additions) {
                    this.writeIndexEntry(out, add);
                }
                List deletions = mut.getDeletions();
                VariableLong.writePositive(out, deletions.size());
                for (IndexEntry del : deletions) {
                    this.writeIndexEntry(out, del);
                }
            }
        }
    }

    private void writeIndexEntry(DataOutput out, IndexEntry entry) {
        out.writeObjectNotNull(entry.field);
        out.writeClassAndObject(entry.value);
    }
}

