/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class CharArraySerializer
extends ArraySerializer
implements AttributeSerializer<char[]> {
    @Override
    public char[] convert(Object value) {
        return (char[])this.convertInternal(value, Character.TYPE, Character.class);
    }

    @Override
    protected Object getArray(int length) {
        return new char[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setChar(array, pos, ((Character)value).charValue());
    }

    @Override
    public char[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getChars(length);
    }

    @Override
    public void write(WriteBuffer buffer, char[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (char anAttribute : attribute) {
                buffer.putChar(anAttribute);
            }
        }
    }
}

