/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryProcessor;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCentricQueryBuilder
implements JanusGraphQuery<GraphCentricQueryBuilder> {
    private static final Logger log = LoggerFactory.getLogger(GraphCentricQueryBuilder.class);
    private final StandardJanusGraphTx tx;
    private final IndexSerializer serializer;
    private final List<PredicateCondition<String, JanusGraphElement>> constraints = new ArrayList<PredicateCondition<String, JanusGraphElement>>(5);
    private final List<List<PredicateCondition<String, JanusGraphElement>>> globalConstraints = new ArrayList<List<PredicateCondition<String, JanusGraphElement>>>();
    private OrderList orders = new OrderList();
    private int limit = Integer.MAX_VALUE;
    private QueryProfiler profiler = QueryProfiler.NO_OP;
    private static final int DEFAULT_NO_LIMIT = 1000;
    private static final int MAX_BASE_LIMIT = 20000;
    private static final int HARD_MAX_LIMIT = 100000;
    private static final double EQUAL_CONDITION_SCORE = 4.0;
    private static final double OTHER_CONDITION_SCORE = 1.0;
    private static final double ORDER_MATCH = 2.0;
    private static final double ALREADY_MATCHED_ADJUSTOR = 0.1;
    private static final double CARDINALITY_SINGE_SCORE = 1000.0;
    private static final double CARDINALITY_OTHER_SCORE = 1000.0;

    public GraphCentricQueryBuilder(StandardJanusGraphTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        this.tx = tx;
        this.serializer = serializer;
    }

    public List<PredicateCondition<String, JanusGraphElement>> getConstraints() {
        return this.constraints;
    }

    public GraphCentricQueryBuilder profiler(QueryProfiler profiler) {
        Preconditions.checkNotNull((Object)profiler);
        this.profiler = profiler;
        return this;
    }

    @Override
    public GraphCentricQueryBuilder has(String key, JanusGraphPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)predicate);
        Preconditions.checkArgument((boolean)predicate.isValidCondition(condition), (String)"Invalid condition: %s", (Object[])new Object[]{condition});
        if (predicate.equals(Contain.NOT_IN)) {
            this.has(key);
        }
        this.constraints.add(new PredicateCondition(key, predicate, condition));
        return this;
    }

    public GraphCentricQueryBuilder has(PropertyKey key, JanusGraphPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        return this.has(key.name(), predicate, condition);
    }

    @Override
    public GraphCentricQueryBuilder has(String key) {
        return this.has(key, (JanusGraphPredicate)Cmp.NOT_EQUAL, null);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key) {
        return this.has(key, (JanusGraphPredicate)Cmp.EQUAL, null);
    }

    @Override
    public GraphCentricQueryBuilder has(String key, Object value) {
        return this.has(key, (JanusGraphPredicate)Cmp.EQUAL, value);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key, Object value) {
        return this.has(key, (JanusGraphPredicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public <T extends Comparable<?>> GraphCentricQueryBuilder interval(String s, T t1, T t2) {
        this.has(s, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, t1);
        return this.has(s, (JanusGraphPredicate)Cmp.LESS_THAN, t2);
    }

    @Override
    public GraphCentricQueryBuilder limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Non-negative limit expected: %s", (Object[])new Object[]{limit});
        this.limit = limit;
        return this;
    }

    @Override
    public GraphCentricQueryBuilder orderBy(String keyName, org.apache.tinkerpop.gremlin.process.traversal.Order order) {
        Preconditions.checkArgument((boolean)this.tx.containsPropertyKey(keyName), (String)"Provided key does not exist: %s", (Object[])new Object[]{keyName});
        PropertyKey key = this.tx.getPropertyKey(keyName);
        Preconditions.checkArgument((key != null && order != null ? 1 : 0) != 0, (Object)"Need to specify and key and an order");
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.dataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object[])new Object[]{key.name(), key.dataType()});
        Preconditions.checkArgument((key.cardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Ordering is undefined on multi-valued key [%s]", (Object[])new Object[]{key.name()});
        Preconditions.checkArgument((!this.orders.containsKey(key) ? 1 : 0) != 0);
        this.orders.add(key, Order.convert(order));
        return this;
    }

    @Override
    public GraphCentricQueryBuilder or(GraphCentricQueryBuilder subQuery) {
        this.globalConstraints.add(subQuery.getConstraints());
        return this;
    }

    @Override
    public Iterable<JanusGraphVertex> vertices() {
        return this.iterables(this.constructQuery(ElementCategory.VERTEX), JanusGraphVertex.class);
    }

    @Override
    public Iterable<JanusGraphEdge> edges() {
        return this.iterables(this.constructQuery(ElementCategory.EDGE), JanusGraphEdge.class);
    }

    @Override
    public Iterable<JanusGraphVertexProperty> properties() {
        return this.iterables(this.constructQuery(ElementCategory.PROPERTY), JanusGraphVertexProperty.class);
    }

    public <E extends JanusGraphElement> Iterable<E> iterables(GraphCentricQuery query, Class<E> aClass) {
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(query, this.tx.elementProcessor), aClass);
    }

    public GraphCentricQuery constructQuery(ElementCategory resultType) {
        QueryProfiler optProfiler = this.profiler.addNested("optimization");
        optProfiler.startTimer();
        if (this.globalConstraints.isEmpty()) {
            this.globalConstraints.add(this.constraints);
        }
        GraphCentricQuery query = this.constructQueryWithoutProfile(resultType);
        optProfiler.stopTimer();
        query.observeWith(this.profiler);
        return query;
    }

    public GraphCentricQuery constructQueryWithoutProfile(ElementCategory resultType) {
        BackendQueryHolder<JointIndexQuery> query;
        MultiCondition conditions;
        Preconditions.checkNotNull((Object)((Object)resultType));
        if (this.limit == 0) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        if (this.globalConstraints.size() == 1) {
            conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
            if (conditions == null) {
                return GraphCentricQuery.emptyQuery(resultType);
            }
        } else {
            conditions = new Or();
            for (List list : this.globalConstraints) {
                And localconditions = QueryUtil.constraints2QNF(this.tx, list);
                if (localconditions == null) {
                    return GraphCentricQuery.emptyQuery(resultType);
                }
                conditions.add(localconditions);
            }
        }
        this.orders.makeImmutable();
        if (this.orders.isEmpty()) {
            this.orders = OrderList.NO_ORDER;
        }
        HashSet indexCandidates = new HashSet();
        ConditionUtil.traversal(conditions, condition -> {
            if (condition instanceof PredicateCondition) {
                RelationType type = (RelationType)((PredicateCondition)condition).getKey();
                Preconditions.checkArgument((type != null && type.isPropertyKey() ? 1 : 0) != 0);
                Iterables.addAll((Collection)indexCandidates, (Iterable)Iterables.filter(((InternalRelationType)type).getKeyIndexes(), indexType -> indexType.getElement() == resultType && (!(conditions instanceof Or) || !indexType.isCompositeIndex() && this.serializer.features((MixedIndexType)indexType).supportNotQueryNormalForm())));
            }
            return true;
        });
        JointIndexQuery jointIndexQuery = new JointIndexQuery();
        boolean isSorted = this.orders.isEmpty();
        HashSet coveredClauses = Sets.newHashSet();
        while (true) {
            IndexType bestCandidate = null;
            double candidateScore = 0.0;
            HashSet candidateSubcover = null;
            boolean candidateSupportsSort = false;
            Object candidateSubCondition = null;
            for (IndexType index : indexCandidates) {
                Object subCondition;
                HashSet subcover = Sets.newHashSet();
                boolean supportsSort = this.orders.isEmpty();
                if (index.hasSchemaTypeConstraint()) {
                    JanusGraphSchemaType type = index.getSchemaTypeConstraint();
                    Map.Entry<Condition, Collection<Object>> equalCon = GraphCentricQueryBuilder.getEqualityConditionValues(conditions, ImplicitKey.LABEL);
                    if (equalCon == null) continue;
                    Collection<Object> labels = equalCon.getValue();
                    assert (labels.size() >= 1);
                    if (labels.size() > 1) {
                        log.warn("The query optimizer currently does not support multiple label constraints in query: {}", (Object)this);
                        continue;
                    }
                    if (!type.name().equals(Iterables.getOnlyElement(labels))) continue;
                    subcover.add(equalCon.getKey());
                }
                if (index.isCompositeIndex()) {
                    subCondition = GraphCentricQueryBuilder.indexCover((CompositeIndexType)index, conditions, subcover);
                } else {
                    subCondition = GraphCentricQueryBuilder.indexCover((MixedIndexType)index, conditions, this.serializer, subcover);
                    if (coveredClauses.isEmpty() && !supportsSort && GraphCentricQueryBuilder.indexCoversOrder((MixedIndexType)index, this.orders)) {
                        supportsSort = true;
                    }
                }
                if (subCondition == null || subcover.isEmpty()) continue;
                double score = 0.0;
                boolean coversAdditionalClause = false;
                for (Condition c : subcover) {
                    double s;
                    double d = s = c instanceof PredicateCondition && ((PredicateCondition)c).getPredicate() == Cmp.EQUAL ? 4.0 : 1.0;
                    if (coveredClauses.contains(c)) {
                        s *= 0.1;
                    } else {
                        coversAdditionalClause = true;
                    }
                    score += s;
                    if (!index.isCompositeIndex()) continue;
                    score += ((CompositeIndexType)index).getCardinality() == Cardinality.SINGLE ? 1000.0 : 1000.0;
                }
                if (supportsSort) {
                    score += 2.0;
                }
                if (!coversAdditionalClause || !(score > candidateScore)) continue;
                candidateScore = score;
                bestCandidate = index;
                candidateSubcover = subcover;
                candidateSubCondition = subCondition;
                candidateSupportsSort = supportsSort;
            }
            if (bestCandidate == null) break;
            if (coveredClauses.isEmpty()) {
                isSorted = candidateSupportsSort;
            }
            coveredClauses.addAll(candidateSubcover);
            if (bestCandidate.isCompositeIndex()) {
                jointIndexQuery.add((CompositeIndexType)bestCandidate, this.serializer.getQuery((CompositeIndexType)bestCandidate, (List)candidateSubCondition));
                continue;
            }
            jointIndexQuery.add((MixedIndexType)bestCandidate, this.serializer.getQuery((MixedIndexType)bestCandidate, (Condition)candidateSubCondition, this.orders));
        }
        if (!coveredClauses.isEmpty()) {
            int indexLimit;
            int n = indexLimit = this.limit == Integer.MAX_VALUE ? 100000 : this.limit;
            if (this.tx.getGraph().getConfiguration().adjustQueryLimit()) {
                indexLimit = this.limit == Integer.MAX_VALUE ? 1000 : Math.min(20000, this.limit);
            }
            indexLimit = Math.min(100000, QueryUtil.adjustLimitForTxModifications(this.tx, coveredClauses.size(), indexLimit));
            jointIndexQuery.setLimit(indexLimit);
            query = new BackendQueryHolder<JointIndexQuery>(jointIndexQuery, coveredClauses.size() == conditions.numChildren(), isSorted);
        } else {
            query = new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), false, isSorted);
        }
        return new GraphCentricQuery(resultType, conditions, this.orders, query, this.limit);
    }

    public static boolean indexCoversOrder(MixedIndexType index, OrderList orders) {
        for (int i = 0; i < orders.size(); ++i) {
            if (index.indexesKey(orders.getKey(i))) continue;
            return false;
        }
        return true;
    }

    public static List<Object[]> indexCover(CompositeIndexType index, Condition<JanusGraphElement> condition, Set<Condition> covered) {
        if (!QueryUtil.isQueryNormalForm(condition)) {
            return null;
        }
        assert (condition instanceof And);
        if (index.getStatus() != SchemaStatus.ENABLED) {
            return null;
        }
        IndexField[] fields = index.getFieldKeys();
        Object[] indexValues = new Object[fields.length];
        HashSet<Condition> coveredClauses = new HashSet<Condition>(fields.length);
        ArrayList<Object[]> indexCovers = new ArrayList<Object[]>(4);
        GraphCentricQueryBuilder.constructIndexCover(indexValues, 0, fields, condition, indexCovers, coveredClauses);
        if (!indexCovers.isEmpty()) {
            covered.addAll(coveredClauses);
            return indexCovers;
        }
        return null;
    }

    private static void constructIndexCover(Object[] indexValues, int position, IndexField[] fields, Condition<JanusGraphElement> condition, List<Object[]> indexCovers, Set<Condition> coveredClauses) {
        if (position >= fields.length) {
            indexCovers.add(indexValues);
        } else {
            IndexField field = fields[position];
            Map.Entry<Condition, Collection<Object>> equalCon = GraphCentricQueryBuilder.getEqualityConditionValues(condition, field.getFieldKey());
            if (equalCon != null) {
                coveredClauses.add(equalCon.getKey());
                assert (equalCon.getValue().size() > 0);
                for (Object value : equalCon.getValue()) {
                    Object[] newValues = Arrays.copyOf(indexValues, fields.length);
                    newValues[position] = value;
                    GraphCentricQueryBuilder.constructIndexCover(newValues, position + 1, fields, condition, indexCovers, coveredClauses);
                }
            }
        }
    }

    private static Map.Entry<Condition, Collection<Object>> getEqualityConditionValues(Condition<JanusGraphElement> condition, RelationType type) {
        for (Condition<JanusGraphElement> c : condition.getChildren()) {
            PredicateCondition atom;
            if (c instanceof Or) {
                Map.Entry<RelationType, Collection> orEqual = QueryUtil.extractOrCondition((Or)c);
                if (orEqual == null || !orEqual.getKey().equals(type) || orEqual.getValue().isEmpty()) continue;
                return new AbstractMap.SimpleImmutableEntry<Condition, Collection<Object>>(c, orEqual.getValue());
            }
            if (!(c instanceof PredicateCondition) || !((RelationType)(atom = (PredicateCondition)c).getKey()).equals(type) || atom.getPredicate() != Cmp.EQUAL || atom.getValue() == null) continue;
            return new AbstractMap.SimpleImmutableEntry<Condition<JanusGraphElement>, ImmutableList>(c, ImmutableList.of((Object)atom.getValue()));
        }
        return null;
    }

    public static Condition<JanusGraphElement> indexCover(MixedIndexType index, Condition<JanusGraphElement> condition, IndexSerializer indexInfo, Set<Condition> covered) {
        if (!indexInfo.features(index).supportNotQueryNormalForm() && !QueryUtil.isQueryNormalForm(condition)) {
            return null;
        }
        if (condition instanceof Or) {
            for (Condition<JanusGraphElement> subClause : condition.getChildren()) {
                if (subClause instanceof And) {
                    for (Condition<JanusGraphElement> subsubClause : condition.getChildren()) {
                        if (GraphCentricQueryBuilder.coversAll(index, subsubClause, indexInfo)) continue;
                        return null;
                    }
                    continue;
                }
                if (GraphCentricQueryBuilder.coversAll(index, subClause, indexInfo)) continue;
                return null;
            }
            covered.add(condition);
            return condition;
        }
        assert (condition instanceof And);
        And<JanusGraphElement> subCondition = new And<JanusGraphElement>(condition.numChildren());
        for (Condition<JanusGraphElement> subClause : condition.getChildren()) {
            if (!GraphCentricQueryBuilder.coversAll(index, subClause, indexInfo)) continue;
            subCondition.add(subClause);
            covered.add(subClause);
        }
        return subCondition.isEmpty() ? null : subCondition;
    }

    private static boolean coversAll(MixedIndexType index, Condition<JanusGraphElement> condition, IndexSerializer indexInfo) {
        if (condition.getType() != Condition.Type.LITERAL) {
            return StreamSupport.stream(condition.getChildren().spliterator(), false).allMatch(child -> GraphCentricQueryBuilder.coversAll(index, child, indexInfo));
        }
        if (!(condition instanceof PredicateCondition)) {
            return false;
        }
        PredicateCondition atom = (PredicateCondition)condition;
        if (atom.getValue() == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)((RelationType)atom.getKey()).isPropertyKey());
        PropertyKey key = (PropertyKey)atom.getKey();
        ParameterIndexField[] fields = index.getFieldKeys();
        ParameterIndexField match = Arrays.stream(fields).filter(field -> field.getStatus() == SchemaStatus.ENABLED).filter(field -> field.getFieldKey().equals(key)).findAny().orElse(null);
        return match != null && indexInfo.supports(index, match, atom.getPredicate());
    }
}

