/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import java.util.Date;
import java.util.UUID;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;

public class JanusGraphDefaultSchemaMaker
implements DefaultSchemaMaker {
    public static final DefaultSchemaMaker INSTANCE = new JanusGraphDefaultSchemaMaker();

    private JanusGraphDefaultSchemaMaker() {
    }

    @Override
    public Cardinality defaultPropertyCardinality(String key) {
        return Cardinality.SINGLE;
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory, Object value) {
        String name = factory.getName();
        Class actualClass = this.determineClass(value);
        return factory.cardinality(this.defaultPropertyCardinality(name)).dataType(actualClass).make();
    }

    @Override
    public boolean ignoreUndefinedQueryTypes() {
        return true;
    }

    protected Class determineClass(Object value) {
        if (value instanceof String) {
            return String.class;
        }
        if (value instanceof Character) {
            return Character.class;
        }
        if (value instanceof Boolean) {
            return Boolean.class;
        }
        if (value instanceof Byte) {
            return Byte.class;
        }
        if (value instanceof Short) {
            return Short.class;
        }
        if (value instanceof Integer) {
            return Integer.class;
        }
        if (value instanceof Long) {
            return Long.class;
        }
        if (value instanceof Float) {
            return Float.class;
        }
        if (value instanceof Double) {
            return Double.class;
        }
        if (value instanceof Date) {
            return Date.class;
        }
        if (value instanceof Geoshape) {
            return Geoshape.class;
        }
        if (value instanceof UUID) {
            return UUID.class;
        }
        return Object.class;
    }
}

