/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphProperty;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphPropertiesStep<E>
extends PropertiesStep<E>
implements HasStepFolder<Element, E>,
Profiling,
MultiQueriable<Element, E> {
    private boolean initialized = false;
    private boolean useMultiQuery = false;
    private Map<JanusGraphVertex, Iterable<? extends JanusGraphProperty>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final List<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphPropertiesStep(PropertiesStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnType(), originalStep.getPropertyKeys());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphPropertiesStep)this).addLabel(arg_0));
        this.hasContainers = new ArrayList<HasContainer>();
        this.limit = Integer.MAX_VALUE;
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    private <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        String[] keys = this.getPropertyKeys();
        query.keys(keys);
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private Iterator<E> convertIterator(Iterable<? extends JanusGraphProperty> iterable) {
        if (this.getReturnType().forProperties()) {
            return iterable.iterator();
        }
        assert (this.getReturnType().forValues());
        return Iterators.transform(iterable.iterator(), Property::value);
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        assert (this.getReturnType().forProperties() || this.orders.isEmpty() && this.hasContainers.isEmpty());
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        ArrayList elements = new ArrayList();
        this.starts.forEachRemaining(elements::add);
        this.starts.add(elements.iterator());
        assert (elements.size() > 0);
        boolean bl = this.useMultiQuery = this.useMultiQuery && elements.stream().allMatch(e -> e.get() instanceof Vertex);
        if (this.useMultiQuery) {
            JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
            elements.forEach(e -> multiQuery.addVertex((Vertex)e.get()));
            this.makeQuery(multiQuery);
            this.multiQueryResults = multiQuery.properties();
        }
    }

    protected Traverser.Admin<E> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    protected Iterator<E> flatMap(Traverser.Admin<Element> traverser) {
        Iterator iterator;
        if (this.useMultiQuery) {
            assert (this.multiQueryResults != null);
            return this.convertIterator(this.multiQueryResults.get(traverser.get()));
        }
        if (traverser.get() instanceof JanusGraphVertex || traverser.get() instanceof WrappedVertex) {
            JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(JanusGraphTraversalUtil.getJanusGraphVertex(traverser).query());
            return this.convertIterator(query.properties());
        }
        if (this.getReturnType().forValues()) {
            assert (this.orders.isEmpty() && this.hasContainers.isEmpty());
            iterator = ((Element)traverser.get()).values(this.getPropertyKeys());
        } else {
            assert (this.orders.isEmpty());
            if (!this.hasContainers.isEmpty()) {
                return Collections.emptyIterator();
            }
            iterator = ((Element)traverser.get()).properties(this.getPropertyKeys());
        }
        if (this.limit != Integer.MAX_VALUE) {
            iterator = Iterators.limit((Iterator)iterator, (int)this.limit);
        }
        return iterator;
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public JanusGraphPropertiesStep<E> clone() {
        JanusGraphPropertiesStep clone = (JanusGraphPropertiesStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        Iterables.addAll(this.hasContainers, has);
    }

    @Override
    public List<HasContainer> addLocalAll(Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for properties step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("LocalOrderBy is not supported for properties step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("LocalLimit is not supported for properties step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for properties step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

