/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.olap.computer.FulgoraElementTraversal;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphVertexStep;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphTraversalUtil {
    public static JanusGraphVertex getJanusGraphVertex(Element v) {
        while (v instanceof WrappedVertex) {
            v = (Element)((WrappedVertex)v).getBaseVertex();
        }
        if (v instanceof JanusGraphVertex) {
            return (JanusGraphVertex)v;
        }
        throw new IllegalArgumentException("Expected traverser of JanusGraph vertex but found: " + v);
    }

    public static JanusGraphVertex getJanusGraphVertex(Traverser<? extends Element> traverser) {
        return JanusGraphTraversalUtil.getJanusGraphVertex((Element)traverser.get());
    }

    public static boolean isEdgeReturnStep(JanusGraphVertexStep vertexStep) {
        return Edge.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static boolean isVertexReturnStep(JanusGraphVertexStep vertexStep) {
        return Vertex.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static Step getNextNonIdentityStep(Step start) {
        Step currentStep = start.getNextStep();
        while (currentStep instanceof IdentityStep) {
            currentStep = currentStep.getNextStep();
        }
        return currentStep;
    }

    public static JanusGraphTransaction getTx(Traversal.Admin<?, ?> traversal) {
        JanusGraphTransaction tx;
        Optional optGraph = TraversalHelper.getRootTraversal((Traversal.Admin)traversal.asAdmin()).getGraph();
        if (traversal instanceof FulgoraElementTraversal) {
            tx = (JanusGraphTransaction)optGraph.get();
        } else {
            if (!optGraph.isPresent()) {
                throw new IllegalArgumentException("Traversal is not bound to a graph: " + traversal);
            }
            Graph graph = (Graph)optGraph.get();
            if (graph instanceof JanusGraphTransaction) {
                tx = (JanusGraphTransaction)graph;
            } else if (graph instanceof JanusGraphBlueprintsGraph) {
                tx = ((JanusGraphBlueprintsGraph)graph).getCurrentThreadTx();
            } else {
                throw new IllegalArgumentException("Traversal is not bound to a JanusGraph Graph, but: " + graph);
            }
        }
        if (tx == null) {
            throw new IllegalArgumentException("Not a valid start step for a JanusGraph traversal: " + traversal);
        }
        if (tx.isOpen()) {
            return tx;
        }
        return ((StandardJanusGraphTx)tx).getNextTx();
    }
}

