/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.RelationTypeMaker;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.system.SystemTypeManager;

public abstract class StandardRelationTypeMaker
implements RelationTypeMaker {
    protected final StandardJanusGraphTx tx;
    protected final IndexSerializer indexSerializer;
    protected final AttributeHandler attributeHandler;
    private String name;
    private boolean isInvisible;
    private final List<PropertyKey> sortKey;
    private Order sortOrder;
    private final List<PropertyKey> signature;
    private Multiplicity multiplicity;
    private SchemaStatus status = SchemaStatus.ENABLED;

    public StandardRelationTypeMaker(StandardJanusGraphTx tx, String name, IndexSerializer indexSerializer, AttributeHandler attributeHandler) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)indexSerializer);
        Preconditions.checkNotNull((Object)attributeHandler);
        this.tx = tx;
        this.indexSerializer = indexSerializer;
        this.attributeHandler = attributeHandler;
        this.name(name);
        this.isInvisible = false;
        this.sortKey = new ArrayList<PropertyKey>(4);
        this.sortOrder = Order.ASC;
        this.signature = new ArrayList<PropertyKey>(4);
        this.multiplicity = Multiplicity.MULTI;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean hasSortKey() {
        return !this.sortKey.isEmpty();
    }

    protected Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    abstract JanusGraphSchemaCategory getSchemaCategory();

    private void checkGeneralArguments() {
        this.checkSortKey(this.sortKey);
        Preconditions.checkArgument((this.sortOrder == Order.ASC || this.hasSortKey() ? 1 : 0) != 0, (Object)"Must define a sort key to use ordering");
        StandardRelationTypeMaker.checkSignature(this.signature);
        Preconditions.checkArgument((boolean)Sets.intersection((Set)Sets.newHashSet(this.sortKey), (Set)Sets.newHashSet(this.signature)).isEmpty(), (Object)"Signature and sort key must be disjoined");
        Preconditions.checkArgument((!this.hasSortKey() || !this.multiplicity.isConstrained() ? 1 : 0) != 0, (Object)"Cannot define a sort-key on constrained edge labels");
    }

    private long[] checkSortKey(List<PropertyKey> sig) {
        for (PropertyKey key : sig) {
            Preconditions.checkArgument((boolean)this.attributeHandler.isOrderPreservingDatatype(key.dataType()), (Object)("Key must have an order-preserving data type to be used as sort key: " + key));
        }
        return StandardRelationTypeMaker.checkSignature(sig);
    }

    private static long[] checkSignature(List<PropertyKey> sig) {
        Preconditions.checkArgument((sig.size() == Sets.newHashSet(sig).size() ? 1 : 0) != 0, (Object)"Signature and sort key cannot contain duplicate types");
        long[] signature = new long[sig.size()];
        for (int i = 0; i < sig.size(); ++i) {
            PropertyKey key = sig.get(i);
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkArgument((!key.dataType().equals(Object.class) ? 1 : 0) != 0, (String)"Signature and sort keys must have a proper declared datatype: %s", (Object[])new Object[]{key.name()});
            signature[i] = key.longId();
        }
        return signature;
    }

    protected final TypeDefinitionMap makeDefinition() {
        this.checkGeneralArguments();
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INVISIBLE, this.isInvisible);
        def.setValue(TypeDefinitionCategory.SORT_KEY, this.checkSortKey(this.sortKey));
        def.setValue(TypeDefinitionCategory.SORT_ORDER, (Object)this.sortOrder);
        def.setValue(TypeDefinitionCategory.SIGNATURE, StandardRelationTypeMaker.checkSignature(this.signature));
        def.setValue(TypeDefinitionCategory.MULTIPLICITY, (Object)this.multiplicity);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)this.status);
        return def;
    }

    public StandardRelationTypeMaker multiplicity(Multiplicity multiplicity) {
        Preconditions.checkNotNull((Object)((Object)multiplicity));
        this.multiplicity = multiplicity;
        return this;
    }

    @Override
    public StandardRelationTypeMaker signature(PropertyKey ... types) {
        Preconditions.checkArgument((types != null && types.length > 0 ? 1 : 0) != 0);
        this.signature.addAll(Arrays.asList(types));
        return this;
    }

    public StandardRelationTypeMaker status(SchemaStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0);
        this.status = status;
        return this;
    }

    public StandardRelationTypeMaker sortKey(PropertyKey ... keys) {
        Preconditions.checkArgument((keys != null && keys.length > 0 ? 1 : 0) != 0);
        this.sortKey.addAll(Arrays.asList(keys));
        return this;
    }

    public StandardRelationTypeMaker sortOrder(Order order) {
        Preconditions.checkNotNull((Object)((Object)order));
        this.sortOrder = order;
        return this;
    }

    public StandardRelationTypeMaker name(String name) {
        SystemTypeManager.throwIfSystemName(this.getSchemaCategory(), name);
        this.name = name;
        return this;
    }

    public StandardRelationTypeMaker invisible() {
        this.isInvisible = true;
        return this;
    }
}

