/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.cassandra;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

public class CassandraBinaryRecordReader
extends RecordReader<StaticBuffer, Iterable<Entry>> {
    private final ColumnFamilyRecordReader reader;
    private KV currentKV;
    private KV incompleteKV;

    public CassandraBinaryRecordReader(ColumnFamilyRecordReader reader) {
        this.reader = reader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.currentKV = this.completeNextKV();
        return null != this.currentKV;
    }

    private KV completeNextKV() throws IOException {
        boolean hasNext;
        KV completedKV = null;
        do {
            if (!(hasNext = this.reader.nextKeyValue())) {
                completedKV = this.incompleteKV;
                this.incompleteKV = null;
                continue;
            }
            StaticArrayBuffer key = StaticArrayBuffer.of((ByteBuffer)this.reader.getCurrentKey());
            SortedMap valueSortedMap = this.reader.getCurrentValue();
            ArrayList<Entry> entries = new ArrayList<Entry>(valueSortedMap.size());
            for (Map.Entry ent : valueSortedMap.entrySet()) {
                ByteBuffer col = (ByteBuffer)ent.getKey();
                ByteBuffer val = ((Cell)ent.getValue()).value();
                entries.add(StaticArrayEntry.of((StaticBuffer)StaticArrayBuffer.of((ByteBuffer)col), (StaticBuffer)StaticArrayBuffer.of((ByteBuffer)val)));
            }
            if (null == this.incompleteKV) {
                this.incompleteKV = new KV(key);
            } else if (!this.incompleteKV.key.equals((Object)key)) {
                completedKV = this.incompleteKV;
                this.incompleteKV = new KV(key);
            }
            this.incompleteKV.addEntries(entries);
        } while (hasNext && null == completedKV);
        return completedKV;
    }

    public StaticBuffer getCurrentKey() throws IOException, InterruptedException {
        return this.currentKV.key;
    }

    public Iterable<Entry> getCurrentValue() throws IOException, InterruptedException {
        return this.currentKV.entries;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }

    private static class KV {
        private final StaticArrayBuffer key;
        private ArrayList<Entry> entries;

        public KV(StaticArrayBuffer key) {
            this.key = key;
        }

        public void addEntries(Collection<Entry> toAdd) {
            if (null == this.entries) {
                this.entries = new ArrayList(toAdd.size());
            }
            this.entries.addAll(toAdd);
        }
    }
}

