/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.hbase;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

public class HBaseBinaryRecordReader
extends RecordReader<StaticBuffer, Iterable<Entry>> {
    private final RecordReader<ImmutableBytesWritable, Result> reader;
    private final byte[] edgestoreFamilyBytes;

    public HBaseBinaryRecordReader(RecordReader<ImmutableBytesWritable, Result> reader, byte[] edgestoreFamilyBytes) {
        this.reader = reader;
        this.edgestoreFamilyBytes = edgestoreFamilyBytes;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.reader.nextKeyValue();
    }

    public StaticBuffer getCurrentKey() throws IOException, InterruptedException {
        return StaticArrayBuffer.of((byte[])((ImmutableBytesWritable)this.reader.getCurrentKey()).copyBytes());
    }

    public Iterable<Entry> getCurrentValue() throws IOException, InterruptedException {
        return new HBaseMapIterable((NavigableMap)((Result)this.reader.getCurrentValue()).getMap().get(this.edgestoreFamilyBytes));
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.reader.getProgress();
    }

    private static class HBaseMapIterator
    implements Iterator<Entry> {
        private final Iterator<Map.Entry<byte[], NavigableMap<Long, byte[]>>> iterator;

        public HBaseMapIterator(Iterator<Map.Entry<byte[], NavigableMap<Long, byte[]>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry next() {
            Map.Entry<byte[], NavigableMap<Long, byte[]>> entry = this.iterator.next();
            byte[] col = entry.getKey();
            byte[] val = entry.getValue().lastEntry().getValue();
            return StaticArrayEntry.of((StaticBuffer)new StaticArrayBuffer(col), (StaticBuffer)new StaticArrayBuffer(val));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class HBaseMapIterable
    implements Iterable<Entry> {
        private final NavigableMap<byte[], NavigableMap<Long, byte[]>> columnValues;

        public HBaseMapIterable(NavigableMap<byte[], NavigableMap<Long, byte[]>> columnValues) {
            Preconditions.checkNotNull(columnValues);
            this.columnValues = columnValues;
        }

        @Override
        public Iterator<Entry> iterator() {
            return new HBaseMapIterator(this.columnValues.entrySet().iterator());
        }
    }
}

