/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopPoolsConfigurable;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;

public abstract class AbstractBinaryInputFormat
extends InputFormat<StaticBuffer, Iterable<Entry>>
implements HadoopPoolsConfigurable {
    protected Configuration hadoopConf;
    protected ModifiableHadoopConfiguration mrConf;
    protected ModifiableConfiguration janusgraphConf;

    public void setConf(Configuration config) {
        super.setConf(config);
        this.mrConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, config);
        this.hadoopConf = config;
        this.janusgraphConf = this.mrConf.getJanusGraphConf();
    }

    public Configuration getConf() {
        return this.hadoopConf;
    }
}

