/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.hadoop.formats.util.GiraphInputFormat;
import org.janusgraph.hadoop.formats.util.JanusGraphVertexDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiraphRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private static final Logger log = LoggerFactory.getLogger(GiraphRecordReader.class);
    private final RecordReader<StaticBuffer, Iterable<Entry>> reader;
    private final GiraphInputFormat.RefCountedCloseable countedDeserializer;
    private JanusGraphVertexDeserializer deserializer;
    private VertexWritable vertex;
    private GraphFilter graphFilter;

    public GiraphRecordReader(GiraphInputFormat.RefCountedCloseable<JanusGraphVertexDeserializer> countedDeserializer, RecordReader<StaticBuffer, Iterable<Entry>> reader) {
        this.countedDeserializer = countedDeserializer;
        this.reader = reader;
        this.deserializer = countedDeserializer.acquire();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
        org.apache.hadoop.conf.Configuration conf = taskAttemptContext.getConfiguration();
        if (conf.get("gremlin.hadoop.graphFilter", null) != null) {
            this.graphFilter = (GraphFilter)VertexProgramHelper.deserialize((Configuration)ConfUtil.makeApacheConfiguration((org.apache.hadoop.conf.Configuration)conf), (String)"gremlin.hadoop.graphFilter");
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            TinkerVertex maybeNullTinkerVertex = this.deserializer.readHadoopVertex((StaticBuffer)this.reader.getCurrentKey(), (Iterable)this.reader.getCurrentValue());
            if (null == maybeNullTinkerVertex) continue;
            this.vertex = new VertexWritable((Vertex)maybeNullTinkerVertex);
            if (this.graphFilter == null) {
                return true;
            }
            Optional vertexWritable = this.vertex.get().applyGraphFilter(this.graphFilter);
            if (!vertexWritable.isPresent()) continue;
            this.vertex.set((Vertex)vertexWritable.get());
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        try {
            this.deserializer = null;
            this.countedDeserializer.release();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.reader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.reader.getProgress();
    }
}

