/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.hadoop.compat.HadoopCompatLoader;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.scan.HadoopScanMapper;
import org.janusgraph.hadoop.scan.HadoopVertexScanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopScanRunner {
    private static final Logger log = LoggerFactory.getLogger(HadoopScanRunner.class);

    public static ScanMetrics runJob(Configuration conf, String confRootField, org.apache.hadoop.conf.Configuration hadoopConf, Class<? extends InputFormat> inputFormat, String jobName, Class<? extends Mapper> mapperClass) throws IOException, InterruptedException, ClassNotFoundException {
        Preconditions.checkArgument((null != hadoopConf ? 1 : 0) != 0);
        Preconditions.checkArgument((null != inputFormat ? 1 : 0) != 0);
        if (null != conf) {
            Preconditions.checkArgument((null != confRootField ? 1 : 0) != 0, (Object)"Configuration root field must be provided when configuration instance is provided");
        }
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        if (null != confRootField) {
            scanConf.set(JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_ROOT, confRootField, new String[0]);
            ConfigNamespace confRoot = HadoopScanMapper.getJobRoot(confRootField);
            ModifiableConfiguration hadoopJobConf = ModifiableHadoopConfiguration.prefixView(confRoot, JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, scanConf);
            if (conf != null) {
                Map jobConfMap = conf.getSubset(confRoot, new String[0]);
                for (Map.Entry jobConfEntry : jobConfMap.entrySet()) {
                    hadoopJobConf.set((ConfigOption)ConfigElement.parse((ConfigNamespace)confRoot, (String)((String)jobConfEntry.getKey())).element, jobConfEntry.getValue(), new String[0]);
                }
            }
        }
        return HadoopScanRunner.runJob(scanConf.getHadoopConfiguration(), inputFormat, jobName, mapperClass);
    }

    public static ScanMetrics runJob(org.apache.hadoop.conf.Configuration hadoopConf, Class<? extends InputFormat> inputFormat, String jobName, Class<? extends Mapper> mapperClass) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)hadoopConf);
        job.setJarByClass(mapperClass);
        job.setJobName(jobName);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setNumReduceTasks(0);
        job.setMapperClass(mapperClass);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setInputFormatClass(inputFormat);
        boolean success = job.waitForCompletion(true);
        if (!success) {
            String f;
            try {
                f = String.format("MapReduce JobID %s terminated abnormally: %s", job.getJobID().toString(), HadoopCompatLoader.DEFAULT_COMPAT.getJobFailureString(job));
            }
            catch (RuntimeException e) {
                f = "Job failed (unable to read job status programmatically -- see MapReduce logs for information)";
            }
            throw new IOException(f);
        }
        return HadoopCompatLoader.DEFAULT_COMPAT.getMetrics(job.getCounters());
    }

    public static ScanMetrics runScanJob(ScanJob scanJob, Configuration conf, String confRootField, org.apache.hadoop.conf.Configuration hadoopConf, Class<? extends InputFormat> inputFormat) throws IOException, InterruptedException, ClassNotFoundException {
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        HadoopScanRunner.tryToLoadClassByName(scanJob);
        scanConf.set(JanusGraphHadoopConfiguration.SCAN_JOB_CLASS, scanJob.getClass().getName(), new String[0]);
        String jobName = HadoopScanMapper.class.getSimpleName() + "[" + scanJob + "]";
        return HadoopScanRunner.runJob(conf, confRootField, hadoopConf, inputFormat, jobName, HadoopScanMapper.class);
    }

    public static ScanMetrics runVertexScanJob(VertexScanJob vertexScanJob, Configuration conf, String confRootField, org.apache.hadoop.conf.Configuration hadoopConf, Class<? extends InputFormat> inputFormat) throws IOException, InterruptedException, ClassNotFoundException {
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        HadoopScanRunner.tryToLoadClassByName(vertexScanJob);
        scanConf.set(JanusGraphHadoopConfiguration.SCAN_JOB_CLASS, vertexScanJob.getClass().getName(), new String[0]);
        String jobName = HadoopScanMapper.class.getSimpleName() + "[" + vertexScanJob + "]";
        return HadoopScanRunner.runJob(conf, confRootField, hadoopConf, inputFormat, jobName, HadoopVertexScanMapper.class);
    }

    private static void tryToLoadClassByName(Object o) throws ClassNotFoundException {
        String scanJobClassname = o.getClass().getName();
        try {
            Class.forName(scanJobClassname);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to locate class with name {}", (Object)scanJobClassname, (Object)e);
            throw e;
        }
    }
}

