/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.gremlin.server.auth;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Map;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialGraph;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphAbstractAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(JanusGraphAbstractAuthenticator.class);
    public static final String CONFIG_DEFAULT_USER = "defaultUsername";
    public static final String CONFIG_DEFAULT_PASSWORD = "defaultPassword";
    private static final String USERNAME_INDEX_NAME = "byUsername";
    protected CredentialGraph credentialStore;
    protected JanusGraph backingGraph;

    public boolean requireAuthentication() {
        return true;
    }

    public abstract Authenticator.SaslNegotiator newSaslNegotiator(InetAddress var1);

    public CredentialGraph createCredentialGraph(JanusGraph graph) {
        return new CredentialGraph((Graph)graph);
    }

    public JanusGraph openGraph(String conf) {
        return JanusGraphFactory.open((String)conf);
    }

    public void setup(Map<String, Object> config) {
        String defaultUser;
        JanusGraph graph;
        logger.info("Initializing authentication with the {}", (Object)this.getClass().getName());
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)String.format("Could not configure a %s - provide a 'config' in the 'authentication' settings", this.getClass().getName()));
        Preconditions.checkState((boolean)config.containsKey("credentialsDb"), (Object)String.format("Credential configuration missing the %s key that points to a graph config file or graph name", "credentialsDb"));
        if (!config.containsKey(CONFIG_DEFAULT_USER) || !config.containsKey(CONFIG_DEFAULT_PASSWORD)) {
            logger.warn(String.format("%s and %s should be defined to bootstrap authentication", CONFIG_DEFAULT_USER, CONFIG_DEFAULT_PASSWORD));
        }
        this.backingGraph = graph = this.openGraph(config.get("credentialsDb").toString());
        this.credentialStore = this.createCredentialGraph(graph);
        graph.tx().rollback();
        ManagementSystem mgmt = (ManagementSystem)graph.openManagement();
        if (!mgmt.containsGraphIndex(USERNAME_INDEX_NAME)) {
            PropertyKey username = mgmt.makePropertyKey("username").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(USERNAME_INDEX_NAME, Vertex.class).addKey(username).unique().buildCompositeIndex();
            mgmt.commit();
            mgmt = (ManagementSystem)graph.openManagement();
            JanusGraphIndex index = mgmt.getGraphIndex(USERNAME_INDEX_NAME);
            if (!index.getIndexStatus(username).equals((Object)SchemaStatus.ENABLED)) {
                try {
                    mgmt = (ManagementSystem)graph.openManagement();
                    mgmt.updateIndex((Index)mgmt.getGraphIndex(USERNAME_INDEX_NAME), SchemaAction.REINDEX);
                    ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)USERNAME_INDEX_NAME).status(new SchemaStatus[]{SchemaStatus.ENABLED})).call();
                    mgmt.commit();
                }
                catch (InterruptedException rude) {
                    mgmt.rollback();
                    throw new RuntimeException("Timed out waiting for byUsername index to be created on credential graph", rude);
                }
            }
        }
        if (this.credentialStore.findUser(defaultUser = config.get(CONFIG_DEFAULT_USER).toString()) == null) {
            this.credentialStore.createUser(defaultUser, config.get(CONFIG_DEFAULT_PASSWORD).toString());
        }
    }
}

