/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class TicketGrantingTicketExpirationPolicy
implements ExpirationPolicy,
InitializingBean {
    private static final Logger log;
    private static final long serialVersionUID = 2136490343650084287L;
    private long maxTimeToLiveInMilliSeconds;
    private long timeToKillInMilliSeconds;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        TicketGrantingTicketExpirationPolicy.ajc$preClinit();
        log = LoggerFactory.getLogger(TicketGrantingTicketExpirationPolicy.class);
    }

    public void setMaxTimeToLiveInMilliSeconds(long maxTimeToLiveInMilliSeconds) {
        this.maxTimeToLiveInMilliSeconds = maxTimeToLiveInMilliSeconds;
    }

    public void setTimeToKillInMilliSeconds(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public void afterPropertiesSet() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        TicketGrantingTicketExpirationPolicy.afterPropertiesSet_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public boolean isExpired(TicketState ticketState) {
        TicketState ticketState2 = ticketState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ticketState2);
        return Conversions.booleanValue((Object)TicketGrantingTicketExpirationPolicy.isExpired_aroundBody3$advice(this, ticketState2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private static final /* synthetic */ void afterPropertiesSet_aroundBody0(TicketGrantingTicketExpirationPolicy ajc$this, JoinPoint joinPoint) {
        Assert.isTrue((ajc$this.maxTimeToLiveInMilliSeconds >= ajc$this.timeToKillInMilliSeconds ? 1 : 0) != 0, (String)"maxTimeToLiveInMilliSeconds must be greater than or equal to timeToKillInMilliSeconds.");
    }

    private static final /* synthetic */ Object afterPropertiesSet_aroundBody1$advice(TicketGrantingTicketExpirationPolicy ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            TicketGrantingTicketExpirationPolicy.afterPropertiesSet_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ boolean isExpired_aroundBody2(TicketGrantingTicketExpirationPolicy ajc$this, TicketState ticketState, JoinPoint joinPoint) {
        if (System.currentTimeMillis() - ticketState.getCreationTime() >= ajc$this.maxTimeToLiveInMilliSeconds) {
            if (log.isDebugEnabled()) {
                log.debug("Ticket is expired due to the time since creation being greater than the maxTimeToLiveInMilliSeconds");
            }
            return true;
        }
        if (System.currentTimeMillis() - ticketState.getLastTimeUsed() >= ajc$this.timeToKillInMilliSeconds) {
            if (log.isDebugEnabled()) {
                log.debug("Ticket is expired due to the time since last use being greater than the timeToKillInMilliseconds");
            }
            return true;
        }
        return false;
    }

    private static final /* synthetic */ Object isExpired_aroundBody3$advice(TicketGrantingTicketExpirationPolicy ajc$this, TicketState ticketState, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)TicketGrantingTicketExpirationPolicy.isExpired_aroundBody2(ajc$this, ticketState, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TicketGrantingTicketExpirationPolicy.java", TicketGrantingTicketExpirationPolicy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.ticket.support.TicketGrantingTicketExpirationPolicy", "", "", "java.lang.Exception", "void"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isExpired", "org.jasig.cas.ticket.support.TicketGrantingTicketExpirationPolicy", "org.jasig.cas.ticket.TicketState", "ticketState", "", "boolean"), 48);
    }
}

