/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.Map;
import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.MockExpireUpdateTicketLogoutManager;
import org.jasig.cas.MockOnlyOneTicketRegistry;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.MixedPrincipalException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CentralAuthenticationServiceImplTests
extends AbstractCentralAuthenticationServiceTest {
    @Test(expected=AuthenticationException.class)
    public void testBadCredentialsOnTicketGrantingTicketCreation() throws Exception {
        this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword()});
    }

    @Test
    public void testGoodCredentialsOnTicketGrantingTicketCreation() throws Exception {
        try {
            Assert.assertNotNull((Object)this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()}));
        }
        catch (TicketException e) {
            Assert.fail((String)"Exception not expected.");
        }
    }

    @Test
    public void testDestroyTicketGrantingTicketWithNonExistantTicket() {
        this.getCentralAuthenticationService().destroyTicketGrantingTicket("test");
    }

    @Test
    public void testDestroyTicketGrantingTicketWithValidTicket() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId);
    }

    @Test(expected=ClassCastException.class)
    public void testDestroyTicketGrantingTicketWithInvalidTicket() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(serviceTicketId);
    }

    @Test
    public void testGrantServiceTicketWithValidTicketGrantingTicket() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
    }

    @Test(expected=TicketException.class)
    public void testGrantServiceTicketWithInvalidTicketGrantingTicket() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId);
        this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TicketException.class)
    public void testGrantServiceTicketWithExpiredTicketGrantingTicket() throws Exception {
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setTicketGrantingTicketExpirationPolicy(new ExpirationPolicy(){
            private static final long serialVersionUID = 1L;

            public boolean isExpired(TicketState ticket) {
                return true;
            }
        });
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        try {
            this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
        }
        finally {
            ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setTicketGrantingTicketExpirationPolicy((ExpirationPolicy)new NeverExpiresExpirationPolicy());
        }
    }

    @Test
    public void testDelegateTicketGrantingTicketWithProperParams() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
        this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId, new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
    }

    @Test(expected=AuthenticationException.class)
    public void testDelegateTicketGrantingTicketWithBadCredentials() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
        this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId, new Credential[]{TestUtils.getBadHttpBasedServiceCredentials()});
    }

    @Test(expected=TicketException.class)
    public void testDelegateTicketGrantingTicketWithBadServiceTicket() throws Exception {
        String ticketId = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketId, TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketId);
        this.getCentralAuthenticationService().delegateTicketGrantingTicket(serviceTicketId, new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
    }

    @Test
    public void testGrantServiceTicketWithValidCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test(expected=AuthenticationException.class)
    public void testGrantServiceTicketWithInvalidCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService(), new Credential[]{TestUtils.getBadHttpBasedServiceCredentials()});
    }

    @Test(expected=MixedPrincipalException.class)
    public void testGrantServiceTicketWithDifferentCredentials() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword("testA")});
        this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword("testB")});
    }

    @Test
    public void testValidateServiceTicketWithExpires() throws Exception {
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setServiceTicketExpirationPolicy((ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 1100L));
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, TestUtils.getService());
        Assert.assertFalse((boolean)this.getTicketRegistry().deleteTicket(serviceTicket));
        ((CentralAuthenticationServiceImpl)this.getCentralAuthenticationService()).setServiceTicketExpirationPolicy((ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }

    @Test
    public void testValidateServiceTicketWithValidService() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, TestUtils.getService());
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void testValidateServiceTicketWithInvalidService() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, TestUtils.getService("test2"));
    }

    @Test(expected=TicketException.class)
    public void testValidateServiceTicketWithInvalidServiceTicket() throws Exception {
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketGrantingTicket);
        this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, TestUtils.getService());
    }

    @Test(expected=TicketException.class)
    public void testValidateServiceTicketNonExistantTicket() throws Exception {
        this.getCentralAuthenticationService().validateServiceTicket("test", TestUtils.getService());
    }

    @Test
    public void testValidateServiceTicketWithoutUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, TestUtils.getService());
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void testValidateServiceTicketWithDefaultUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("testDefault");
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void testValidateServiceTicketWithUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("eduPersonTest");
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, svc);
        Assert.assertEquals((Object)"developer", (Object)assertion.getPrimaryAuthentication().getPrincipal().getId());
    }

    @Test
    public void testValidateServiceTicketNoAttributesReturned() throws Exception {
        Service service = TestUtils.getService();
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)0L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void testValidateServiceTicketReturnAllAttributes() throws Exception {
        Service service = TestUtils.getService("eduPersonTest");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((long)3L, (long)auth.getPrincipal().getAttributes().size());
    }

    @Test
    public void testValidateServiceTicketReturnOnlyAllowedAttribute() throws Exception {
        Service service = TestUtils.getService("eduPersonTestInvalid");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Map attributes = auth.getPrincipal().getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        Assert.assertEquals((Object)"adopters", attributes.get("groupMembership"));
    }

    @Test
    public void testValidateServiceTicketAnonymous() throws Exception {
        Service service = TestUtils.getService("testAnonymous");
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, service);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, service);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertNotEquals((Object)cred.getUsername(), (Object)auth.getPrincipal().getId());
    }

    @Test
    public void testValidateServiceTicketWithInvalidUsernameAttribute() throws Exception {
        UsernamePasswordCredential cred = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String ticketGrantingTicket = this.getCentralAuthenticationService().createTicketGrantingTicket(new Credential[]{cred});
        Service svc = TestUtils.getService("eduPersonTestInvalid");
        String serviceTicket = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicket, svc);
        Assertion assertion = this.getCentralAuthenticationService().validateServiceTicket(serviceTicket, svc);
        Authentication auth = assertion.getPrimaryAuthentication();
        Assert.assertEquals((Object)auth.getPrincipal().getId(), (Object)cred.getUsername());
    }

    @Test
    public void authenticateTwiceWithRenew() throws TicketException, AuthenticationException {
        CentralAuthenticationService cas = this.getCentralAuthenticationService();
        Service svc = TestUtils.getService("testDefault");
        UsernamePasswordCredential goodCredential = TestUtils.getCredentialsWithSameUsernameAndPassword();
        String tgtId = cas.createTicketGrantingTicket(new Credential[]{goodCredential});
        cas.grantServiceTicket(tgtId, svc);
        String st2Id = cas.grantServiceTicket(tgtId, svc, new Credential[]{goodCredential});
        Assertion assertion = cas.validateServiceTicket(st2Id, svc);
        Cas20WithoutProxyingValidationSpecification validationSpecification = new Cas20WithoutProxyingValidationSpecification();
        Assert.assertTrue((boolean)validationSpecification.isSatisfiedBy(assertion));
    }

    @Test
    public void testDestroyRemoteRegistry() throws TicketException, AuthenticationException {
        MockOnlyOneTicketRegistry registry = new MockOnlyOneTicketRegistry();
        TicketGrantingTicketImpl tgt = new TicketGrantingTicketImpl("TGT-1", (Authentication)Mockito.mock(Authentication.class), (ExpirationPolicy)Mockito.mock(ExpirationPolicy.class));
        MockExpireUpdateTicketLogoutManager logoutManager = new MockExpireUpdateTicketLogoutManager(registry);
        registry.addTicket((Ticket)tgt);
        CentralAuthenticationServiceImpl cas = new CentralAuthenticationServiceImpl((TicketRegistry)registry, null, null, null, null, null, null, null, (LogoutManager)logoutManager);
        cas.destroyTicketGrantingTicket(tgt.getId());
    }
}

