/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.OneTimePasswordCredential;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.util.StringUtils;

public class TestOneTimePasswordAuthenticationHandler
implements AuthenticationHandler {
    @NotNull
    private final Map<String, String> credentialMap;
    private String name;

    public TestOneTimePasswordAuthenticationHandler(Map<String, String> credentialMap) {
        this.credentialMap = credentialMap;
    }

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        OneTimePasswordCredential otp = (OneTimePasswordCredential)credential;
        String valueOnRecord = this.credentialMap.get(otp.getId());
        if (otp.getPassword().equals(this.credentialMap.get(otp.getId()))) {
            return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)otp), (Principal)new SimplePrincipal(otp.getId()));
        }
        throw new FailedLoginException();
    }

    public boolean supports(Credential credential) {
        return credential instanceof OneTimePasswordCredential;
    }

    public String getName() {
        if (StringUtils.hasText((String)this.name)) {
            return this.name;
        }
        return this.getClass().getSimpleName();
    }

    public void setName(String name) {
        this.name = name;
    }
}

